/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.core.io.PlaceholderFile;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.gui.core.GUIHelper;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.spreadsheettable.AbstractProcessSelectedRows;
import adams.gui.dialog.SimplePreviewBrowserDialog;
import java.awt.Component;

public class PreviewSelectedFile
extends AbstractProcessSelectedRows {
    private static final long serialVersionUID = 7786133414905315983L;
    protected SpreadSheetColumnIndex m_Column;

    public String globalInfo() {
        return "Allows the user to preview the selected file in the specified column.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("column", "column", (Object)new SpreadSheetColumnIndex("first"));
    }

    public void setColumn(SpreadSheetColumnIndex value) {
        this.m_Column = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column with the file names.";
    }

    public int minNumRows() {
        return 1;
    }

    public int maxNumRows() {
        return 1;
    }

    public String getIconName() {
        return "previewbrowser.png";
    }

    protected String getDefaultMenuItem() {
        return "Preview selected file";
    }

    protected boolean doProcessSelectedRows(SpreadSheetTable table, SpreadSheet sheet, int[] actRows, int[] selRows) {
        this.m_Column.setData(sheet);
        int col = this.m_Column.getIntIndex();
        if (col == -1) {
            GUIHelper.showErrorMessage((Component)table.getParent(), (String)("Failed to locate column:" + (Object)((Object)this.m_Column)));
            return false;
        }
        SimplePreviewBrowserDialog dialog = new SimplePreviewBrowserDialog();
        dialog.open(new PlaceholderFile(sheet.getCell(actRows[0], col).toString()));
        dialog.setLocationRelativeTo((Component)table.getParent());
        dialog.setVisible(true);
        dialog.setDefaultCloseOperation(2);
        return true;
    }
}

