/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.gui.core.BaseMenu;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.MultiPagePane;
import adams.gui.tools.sqlworkbench.SqlQueryPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class SqlWorkbenchPanel
extends BasePanel
implements MenuBarProvider {
    private static final long serialVersionUID = -441129668621939313L;
    protected JMenuBar m_MenuBar;
    protected MultiPagePane m_MultiPagePane;
    protected JMenuItem m_MenuItemNewQuery;
    protected JMenuItem m_MenuItemCloseQuery;
    protected JMenuItem m_MenuItemCloseAllQueries;
    protected JMenuItem m_MenuItemClose;
    protected int m_Counter;

    protected void initialize() {
        super.initialize();
        this.m_Counter = 0;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_MultiPagePane = new MultiPagePane();
        this.m_MultiPagePane.setMaxPageCloseUndo(10);
        this.add((Component)this.m_MultiPagePane, "Center");
    }

    protected void finishInit() {
        super.finishInit();
        this.newQuery();
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            BaseMenu menu = new BaseMenu("Queries");
            result.add((JMenu)menu);
            menu.setMnemonic('Q');
            menu.addChangeListener(e -> this.updateMenu());
            JMenuItem menuitem = new JMenuItem("New query", GUIHelper.getIcon((String)"new.gif"));
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed N"));
            menuitem.addActionListener(e -> this.newQuery());
            menu.add(menuitem);
            this.m_MenuItemNewQuery = menuitem;
            menu.addSeparator();
            menuitem = new JMenuItem("Close query", GUIHelper.getIcon((String)"close_tab_focused.gif"));
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed W"));
            menuitem.addActionListener(e -> this.closeQuery());
            menu.add(menuitem);
            this.m_MenuItemCloseQuery = menuitem;
            menuitem = new JMenuItem("Close all queries", GUIHelper.getEmptyIcon());
            menuitem.addActionListener(e -> this.closeAllQueries());
            menu.add(menuitem);
            this.m_MenuItemCloseAllQueries = menuitem;
            menu.addSeparator();
            menuitem = new JMenuItem("Close", GUIHelper.getIcon((String)"exit.png"));
            menuitem.addActionListener(e -> this.closeParent());
            menu.add(menuitem);
            this.m_MenuItemClose = menuitem;
            this.m_MenuBar = result;
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void updateMenu() {
        this.m_MenuItemCloseQuery.setEnabled(this.m_MultiPagePane.getSelectedIndex() > -1);
        this.m_MenuItemCloseAllQueries.setEnabled(this.m_MultiPagePane.getPageCount() > 0);
    }

    public void newQuery() {
        ++this.m_Counter;
        this.m_MultiPagePane.addPage("Query-" + this.m_Counter, (Component)((Object)new SqlQueryPanel()));
    }

    public void closeQuery() {
        if (this.m_MultiPagePane.getPageCount() < 1) {
            return;
        }
        this.m_MultiPagePane.removeSelectedPage();
    }

    public void closeAllQueries() {
        this.m_MultiPagePane.removeAllPages();
    }
}

