/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.RowComparator;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.event.SortSetupEvent;
import adams.gui.event.SortSetupListener;
import adams.gui.tools.spreadsheetviewer.SortDefinitionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;

public class SortPanel
extends BasePanel {
    private static final long serialVersionUID = 7929780439384161250L;
    protected SpreadSheet m_Sheet;
    protected List<SortDefinitionPanel> m_Panels;
    protected GridLayout m_Layout;
    protected BasePanel m_PanelDefinitions;
    protected BasePanel m_PanelButtons;
    protected BaseButton m_ButtonReset;
    protected BaseButton m_ButtonAdd;
    protected List<String> m_ColumnNames;
    protected HashSet<SortSetupListener> m_SortSetupListeners;

    protected void initialize() {
        super.initialize();
        this.m_Panels = new ArrayList<SortDefinitionPanel>();
        this.m_ColumnNames = new ArrayList<String>();
        this.m_SortSetupListeners = new HashSet();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Layout = new GridLayout(0, 1);
        this.m_PanelDefinitions = new BasePanel((LayoutManager)this.m_Layout);
        this.add((Component)this.m_PanelDefinitions, "Center");
        this.m_PanelButtons = new BasePanel((LayoutManager)new FlowLayout(0));
        this.add((Component)this.m_PanelButtons, "North");
        this.m_ButtonReset = new BaseButton((Icon)GUIHelper.getIcon((String)"new.gif"));
        this.m_ButtonReset.setToolTipText("Click to reset the conditions");
        this.m_ButtonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortPanel.this.resetDefinitions();
            }
        });
        this.m_PanelButtons.add((Component)this.m_ButtonReset);
        this.m_ButtonAdd = new BaseButton((Icon)GUIHelper.getIcon((String)"add.gif"));
        this.m_ButtonAdd.setToolTipText("Click to add a condition");
        this.m_ButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortPanel.this.addDefinition();
            }
        });
        this.m_PanelButtons.add((Component)this.m_ButtonAdd);
    }

    protected void finishInit() {
        super.finishInit();
        this.reset();
    }

    public boolean setSpreadSheet(SpreadSheet value) {
        boolean mustReset = this.m_Sheet == null || this.m_Sheet.equalsHeader(value) != null;
        this.m_Sheet = value;
        if (mustReset) {
            this.reset();
        }
        return mustReset;
    }

    public SpreadSheet getSpreadSheet() {
        return this.m_Sheet;
    }

    public List<String> getColumnNames() {
        return this.m_ColumnNames;
    }

    public void resetDefinitions() {
        this.m_Panels.clear();
        SortDefinitionPanel panel = new SortDefinitionPanel(this);
        this.m_Panels.add(panel);
        this.update();
        this.notifySortSetupListeners(new SortSetupEvent(this, null, SortSetupEvent.EventType.RESET));
    }

    public void addDefinition() {
        SortDefinitionPanel panel = new SortDefinitionPanel(this);
        this.m_Panels.add(panel);
        this.update();
        this.notifySortSetupListeners(new SortSetupEvent(this, panel, SortSetupEvent.EventType.ADD));
    }

    public void removeDefinition(SortDefinitionPanel panel) {
        if (this.m_Panels.remove((Object)panel)) {
            this.update();
            this.notifySortSetupListeners(new SortSetupEvent(this, panel, SortSetupEvent.EventType.REMOVE));
        }
    }

    public void reset() {
        this.m_Panels.clear();
        this.m_ColumnNames.clear();
        if (this.m_Sheet != null) {
            for (Cell cell : this.m_Sheet.getHeaderRow().cells()) {
                this.m_ColumnNames.add(cell.getContent());
            }
        }
        this.update();
        this.notifySortSetupListeners(new SortSetupEvent(this, null, SortSetupEvent.EventType.RESET));
    }

    public boolean isFirstDefinition(SortDefinitionPanel panel) {
        return this.m_Panels.size() > 0 && this.m_Panels.get(0) == panel;
    }

    public boolean isLastDefinition(SortDefinitionPanel panel) {
        return this.m_Panels.size() > 0 && this.m_Panels.get(this.m_Panels.size() - 1) == panel;
    }

    public boolean moveDefinition(SortDefinitionPanel panel, boolean up) {
        boolean result = false;
        int index = this.m_Panels.indexOf((Object)panel);
        if (up && !this.isFirstDefinition(panel)) {
            this.m_Panels.remove(index);
            this.m_Panels.add(index - 1, panel);
            result = true;
        } else if (!up && !this.isLastDefinition(panel)) {
            this.m_Panels.remove(index);
            this.m_Panels.add(index + 1, panel);
            result = true;
        }
        this.update();
        this.notifySortSetupListeners(new SortSetupEvent(this, panel, SortSetupEvent.EventType.MOVED));
        return result;
    }

    protected void update() {
        this.m_PanelDefinitions.removeAll();
        this.m_Layout.setRows(this.m_Panels.size());
        for (SortDefinitionPanel panel : this.m_Panels) {
            this.m_PanelDefinitions.add((Component)((Object)panel));
        }
        this.revalidate();
        if (this.getParentDialog() != null) {
            this.getParentDialog().pack();
        }
        for (SortDefinitionPanel panel : this.m_Panels) {
            panel.updateButtons();
        }
    }

    public boolean isValidSetup() {
        HashSet<String> names = new HashSet<String>();
        for (SortDefinitionPanel panel : this.m_Panels) {
            if (names.contains(panel.getColumnName())) {
                return false;
            }
            names.add(panel.getColumnName());
        }
        return names.size() > 0;
    }

    public RowComparator getComparator() {
        if (!this.isValidSetup()) {
            return null;
        }
        int[] indices = new int[this.m_Panels.size()];
        boolean[] ascending = new boolean[this.m_Panels.size()];
        for (int i = 0; i < this.m_Panels.size(); ++i) {
            SortDefinitionPanel panel = this.m_Panels.get(i);
            indices[i] = this.m_ColumnNames.indexOf(panel.getColumnName());
            ascending[i] = panel.isAscending();
        }
        RowComparator result = new RowComparator(indices, ascending);
        return result;
    }

    public void addSortSetupListener(SortSetupListener l) {
        this.m_SortSetupListeners.add(l);
    }

    public void removeSortSetupListener(SortSetupListener l) {
        this.m_SortSetupListeners.remove(l);
    }

    public void notifySortSetupListeners(SortSetupEvent e) {
        for (SortSetupListener l : this.m_SortSetupListeners) {
            l.sortSetupChanged(e);
        }
    }
}

