/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer.tab;

import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.tools.spreadsheetviewer.SpreadSheetPanel;
import adams.gui.tools.spreadsheetviewer.tab.AbstractViewerTab;
import adams.gui.tools.spreadsheetviewer.tab.SelectionAwareViewerTab;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.table.TableModel;

public class Information
extends AbstractViewerTab
implements SelectionAwareViewerTab {
    private static final long serialVersionUID = -4215008790991120558L;
    protected SortableAndSearchableTable m_Table;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Table = new SortableAndSearchableTable();
        this.m_Table.setAutoResizeMode(4);
        this.add((Component)new BaseScrollPane((Component)this.m_Table), "Center");
    }

    @Override
    public String getTitle() {
        return "Info";
    }

    @Override
    public void sheetSelectionChanged(SpreadSheetPanel panel, int[] rows) {
        if (panel == null) {
            return;
        }
        SpreadSheet sheet = panel.getSheet();
        DefaultSpreadSheet info = new DefaultSpreadSheet();
        HeaderRow row = info.getHeaderRow();
        row.addCell("K").setContent("Key");
        row.addCell("V").setContent("Value");
        if (sheet.getName() != null) {
            row = info.addRow();
            row.addCell("K").setContent("Name");
            row.addCell("V").setContent(sheet.getName());
        }
        row = info.addRow();
        row.addCell("K").setContent("Rows");
        row.addCell("V").setContent(Integer.valueOf(sheet.getRowCount()));
        row = info.addRow();
        row.addCell("K").setContent("Columns");
        row.addCell("V").setContent(Integer.valueOf(sheet.getColumnCount()));
        row = info.addRow();
        row.addCell("K").setContent("Selected rows");
        row.addCell("V").setContent(Integer.valueOf(rows.length));
        SpreadSheetTableModel model = new SpreadSheetTableModel((SpreadSheet)info);
        model.setUseSimpleHeader(true);
        model.setShowRowColumn(false);
        this.m_Table.setModel((TableModel)model);
    }
}

