/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer.tab;

import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.SpreadSheetQuery;
import adams.gui.core.BaseButton;
import adams.gui.core.GUIHelper;
import adams.gui.core.SpreadSheetQueryEditorPanel;
import adams.gui.dialog.TextDialog;
import adams.gui.tools.spreadsheetviewer.MultiPagePane;
import adams.gui.tools.spreadsheetviewer.tab.AbstractViewerTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Query
extends AbstractViewerTab {
    private static final long serialVersionUID = -4215008790991120558L;
    protected SpreadSheetQueryEditorPanel m_PanelQuery;
    protected BaseButton m_ButtonHelp;
    protected BaseButton m_ButtonExecute;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelQuery = new SpreadSheetQueryEditorPanel();
        this.m_PanelQuery.setWordWrap(true);
        this.m_PanelQuery.getTextPane().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            protected void update() {
                Query.this.m_ButtonExecute.setEnabled(Query.this.getCurrentPanel() != null && !Query.this.m_PanelQuery.getQuery().isEmpty());
            }
        });
        this.add((Component)((Object)this.m_PanelQuery), "Center");
        JPanel panelButtons = new JPanel(new BorderLayout());
        this.add(panelButtons, "South");
        JPanel panel = new JPanel(new FlowLayout(2));
        panelButtons.add((Component)panel, "East");
        this.m_ButtonHelp = new BaseButton("Help");
        this.m_ButtonHelp.setMnemonic('H');
        this.m_ButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Query.this.showHelp();
            }
        });
        panel.add((Component)this.m_ButtonHelp);
        this.m_ButtonExecute = new BaseButton("Execute");
        this.m_ButtonExecute.setMnemonic('E');
        this.m_ButtonExecute.setEnabled(false);
        this.m_ButtonExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Query.this.performQuery();
            }
        });
        panel.add((Component)this.m_ButtonExecute);
    }

    @Override
    public String getTitle() {
        return "Query";
    }

    protected void performQuery() {
        SpreadSheet sheet = this.getCurrentPanel().getSheet();
        SpreadSheetQuery query = new SpreadSheetQuery();
        query.setQuery(this.m_PanelQuery.getQuery());
        String msg = query.setUp();
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)msg);
            query.cleanUp();
            return;
        }
        query.input(new Token((Object)sheet));
        msg = query.execute();
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)msg);
            query.cleanUp();
            return;
        }
        Token output = null;
        if (query.hasPendingOutput()) {
            output = query.output();
        }
        if (output != null) {
            sheet = (SpreadSheet)output.getPayload();
            MultiPagePane tabbedPane = this.getOwner().getOwner().getMultiPagePane();
            tabbedPane.addPage(tabbedPane.newTitle(), sheet);
        }
        query.cleanUp();
    }

    protected void showHelp() {
        String help = this.m_PanelQuery.getAdditionalInformation();
        TextDialog dlg = new TextDialog();
        dlg.setDefaultCloseOperation(2);
        dlg.setDialogTitle("Help");
        dlg.setContent(help);
        dlg.setLineWrap(true);
        dlg.setEditable(false);
        dlg.setVisible(true);
    }
}

