/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.sqlworkbench;

import adams.core.Utils;
import adams.core.base.BasePassword;
import adams.core.logging.LoggingLevel;
import adams.core.logging.LoggingSupporter;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionProvider;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTextField;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanel;
import adams.gui.dialog.ApprovalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;

public class SqlConnectionPanel
extends BasePanel
implements DatabaseConnectionProvider {
    private static final long serialVersionUID = 8008764357731780782L;
    protected JLabel m_LabelConnection;
    protected BaseButton m_ButtonConnection;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    protected void initialize() {
        super.initialize();
        this.m_DatabaseConnection = DatabaseConnection.getSingleton();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_LabelConnection = new JLabel();
        this.add(this.m_LabelConnection, "Center");
        this.m_ButtonConnection = new BaseButton("...");
        this.m_ButtonConnection.setToolTipText("Opens dialog to select database connection");
        this.m_ButtonConnection.addActionListener(e -> this.selectConnection());
        this.add((Component)this.m_ButtonConnection, "East");
    }

    protected void finishInit() {
        super.finishInit();
        this.updateConnection();
    }

    protected void selectConnection() {
        ParameterPanel panelParameters = new ParameterPanel();
        BaseTextField textURL = new BaseTextField(20);
        textURL.setText(this.getDatabaseConnection().getURL());
        panelParameters.addParameter("_URL", (Component)textURL);
        BaseTextField textUser = new BaseTextField(20);
        textUser.setText(this.getDatabaseConnection().getUser());
        panelParameters.addParameter("U_ser", (Component)textUser);
        JPasswordField textPassword = new JPasswordField(20);
        textPassword.setText(this.getDatabaseConnection().getPassword().getValue());
        textPassword.setEchoChar('*');
        panelParameters.addParameter("_Password", (Component)textPassword);
        BaseCheckBox checkBoxShowPassword = new BaseCheckBox();
        checkBoxShowPassword.setSelected(false);
        checkBoxShowPassword.addActionListener(e -> textPassword.setEchoChar(checkBoxShowPassword.isSelected() ? (char)'\u0000' : (char)'*'));
        panelParameters.addParameter("Sho_w password", (Component)checkBoxShowPassword);
        BaseComboBox comboBoxLoggingLevel = new BaseComboBox((Object[])LoggingLevel.values());
        comboBoxLoggingLevel.setSelectedItem((Object)this.getDatabaseConnection().getLoggingLevel());
        panelParameters.addParameter("_Logging level", (Component)comboBoxLoggingLevel);
        ApprovalDialog dialog = this.getParentDialog() != null ? new ApprovalDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(this.getParentFrame(), true);
        dialog.setTitle("Connect to database");
        dialog.setDefaultCloseOperation(2);
        dialog.getContentPane().add((Component)panelParameters, "Center");
        dialog.setApproveCaption("Connect");
        dialog.setApproveVisible(true);
        dialog.setCancelVisible(true);
        dialog.setDiscardVisible(false);
        dialog.pack();
        dialog.setLocationRelativeTo((Component)this.getParent());
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return;
        }
        this.m_DatabaseConnection = DatabaseConnection.getSingleton((String)textURL.getText(), (String)textUser.getText(), (BasePassword)new BasePassword(textPassword.getText()));
        this.m_DatabaseConnection.setLoggingLevel((LoggingLevel)comboBoxLoggingLevel.getSelectedItem());
        String error = null;
        if (!this.m_DatabaseConnection.isConnected()) {
            try {
                this.m_DatabaseConnection.connect();
                if (!this.m_DatabaseConnection.isConnected()) {
                    error = "Failed to connect to: " + textURL.getText();
                }
            }
            catch (Exception e2) {
                error = Utils.handleException((LoggingSupporter)this.m_DatabaseConnection, (String)("Failed to connect to: " + textURL.getText()), (Throwable)e2);
            }
        }
        if (error != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), error);
        }
        this.updateConnection();
    }

    protected void updateConnection() {
        this.m_LabelConnection.setText((this.m_DatabaseConnection.getUser().isEmpty() ? "" : this.m_DatabaseConnection.getUser() + "@") + this.m_DatabaseConnection.getURL());
    }

    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_DatabaseConnection;
    }
}

