/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.sqlworkbench;

import adams.core.Utils;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.sql.DefaultTypeMapper;
import adams.data.spreadsheet.sql.Reader;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnectionProvider;
import adams.db.SQL;
import adams.db.SQLStatement;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.BaseTextArea;
import adams.gui.core.Fonts;
import adams.gui.core.GUIHelper;
import adams.gui.core.SearchPanel;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.dialog.SQLStatementPanel;
import adams.gui.tools.sqlworkbench.SqlConnectionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.ResultSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;

public class SqlQueryPanel
extends BasePanel
implements DatabaseConnectionProvider {
    private static final long serialVersionUID = -7292928176878371096L;
    protected SqlConnectionPanel m_PanelConnection;
    protected BaseSplitPane m_SplitPane;
    protected SQLStatementPanel m_PanelQuery;
    protected JPanel m_PanelTable;
    protected SpreadSheetTable m_TableResults;
    protected SearchPanel m_PanelTableSearch;
    protected JPanel m_PanelText;
    protected BaseTextArea m_TextResults;
    protected JPanel m_PanelNoResult;
    protected BaseButton m_ButtonExecute;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelConnection = new SqlConnectionPanel();
        this.m_PanelConnection.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)((Object)this.m_PanelConnection), "North");
        this.m_SplitPane = new BaseSplitPane(0);
        this.m_SplitPane.setDividerLocation(250);
        this.m_SplitPane.setUISettingsParameters(((Object)((Object)this)).getClass(), "Divider");
        this.add((Component)this.m_SplitPane, "Center");
        this.m_PanelQuery = new SQLStatementPanel();
        this.m_SplitPane.setTopComponent((Component)this.m_PanelQuery);
        this.m_PanelQuery.getQueryPanel().getTextPane().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 88 && e.getModifiersEx() == 512) {
                    e.consume();
                    SqlQueryPanel.this.execute();
                }
                if (!e.isConsumed()) {
                    super.keyPressed(e);
                }
            }
        });
        this.m_ButtonExecute = new BaseButton((Icon)GUIHelper.getIcon((String)"run.gif"));
        this.m_ButtonExecute.addActionListener(e -> this.execute());
        this.m_ButtonExecute.setToolTipText("Executes the query (Alt+X)");
        this.m_PanelQuery.getButtonsLeft().add((Component)this.m_ButtonExecute);
        this.m_PanelNoResult = new JPanel();
        this.m_SplitPane.setBottomComponent((Component)this.m_PanelNoResult);
        this.m_TableResults = new SpreadSheetTable(new SpreadSheetTableModel());
        this.m_TableResults.setShowSimpleCellPopupMenu(true);
        this.m_TableResults.setShowSimpleHeaderPopupMenu(true);
        this.m_TableResults.setUseOptimalColumnWidths(false);
        this.m_PanelTable = new JPanel(new BorderLayout());
        this.m_PanelTable.add((Component)new BaseScrollPane((Component)this.m_TableResults), "Center");
        this.m_PanelTableSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, false);
        this.m_PanelTableSearch.addSearchListener(e -> this.m_TableResults.search(e.getParameters().getSearchString(), e.getParameters().isRegExp()));
        this.m_PanelTable.add((Component)this.m_PanelTableSearch, "South");
        this.m_TextResults = new BaseTextArea(5, 40);
        this.m_TextResults.setTextFont(Fonts.getMonospacedFont());
        this.m_PanelText = new JPanel(new BorderLayout());
        this.m_PanelText.add((Component)new BaseScrollPane((Component)this.m_TextResults), "Center");
    }

    public void setQuery(String query) {
        this.m_PanelQuery.setStatement(new SQLStatement(query));
    }

    public String getQuery() {
        return this.m_PanelQuery.getStatement().getValue();
    }

    public void execute() {
        final String query = this.getQuery().trim();
        if (query.isEmpty()) {
            return;
        }
        SwingWorker worker = new SwingWorker(){
            protected SpreadSheet m_Sheet = null;
            protected String m_Error = null;
            protected String m_Result = null;

            protected Object doInBackground() throws Exception {
                try {
                    SQL sql = new SQL(SqlQueryPanel.this.m_PanelConnection.getDatabaseConnection());
                    if (query.toLowerCase().startsWith("select ")) {
                        Reader reader = new Reader(new DefaultTypeMapper(), DenseDataRow.class);
                        ResultSet rs = sql.getResultSet(query);
                        this.m_Sheet = reader.read(rs, 0);
                    } else if (sql.execute(query).booleanValue()) {
                        this.m_Error = "Query generated results unexpectedly!";
                    } else {
                        this.m_Result = "Query succeeded!";
                    }
                }
                catch (Exception e) {
                    this.m_Error = "Failed to execute query:\n\n" + query + "\n\nException:\n\n" + Utils.throwableToString((Throwable)e);
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                int location = SqlQueryPanel.this.m_SplitPane.getDividerLocation();
                if (this.m_Error != null) {
                    SqlQueryPanel.this.m_TextResults.setText(this.m_Error);
                    SqlQueryPanel.this.m_SplitPane.setBottomComponent((Component)SqlQueryPanel.this.m_PanelText);
                } else {
                    SqlQueryPanel.this.m_PanelQuery.addStatementToHistory();
                    if (this.m_Sheet != null) {
                        SqlQueryPanel.this.m_TableResults.setModel((TableModel)new SpreadSheetTableModel(this.m_Sheet));
                        SqlQueryPanel.this.m_TableResults.setOptimalColumnWidthBounded(150);
                        SqlQueryPanel.this.m_SplitPane.setBottomComponent((Component)SqlQueryPanel.this.m_PanelTable);
                    } else {
                        SqlQueryPanel.this.m_TextResults.setText(this.m_Result);
                        SqlQueryPanel.this.m_SplitPane.setBottomComponent((Component)SqlQueryPanel.this.m_PanelText);
                    }
                }
                SqlQueryPanel.this.m_SplitPane.setDividerLocation(location);
            }
        };
        worker.execute();
    }

    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_PanelConnection.getDatabaseConnection();
    }
}

