/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseRegExp;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.columnfinder.ByName;
import adams.data.spreadsheet.columnfinder.ColumnFinder;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.SpreadSheetColumnFilter;
import adams.flow.transformer.SpreadSheetFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetColumnFilterTest
extends AbstractFlowTest {
    public SpreadSheetColumnFilterTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.csv")});
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetColumnFilterTest.class);
    }

    public Actor getActor() {
        Flow flow = new Flow();
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            Actor[] tmp1 = new Actor[4];
            FileSupplier tmp2 = new FileSupplier();
            argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("files");
            tmp2.setFiles(new PlaceholderFile[]{(PlaceholderFile)argOption.valueOf("${TMP}/bolts.csv")});
            tmp1[0] = tmp2;
            SpreadSheetFileReader tmp4 = new SpreadSheetFileReader();
            argOption = (AbstractArgumentOption)tmp4.getOptionManager().findByProperty("reader");
            CsvSpreadSheetReader tmp6 = new CsvSpreadSheetReader();
            tmp4.setReader((SpreadSheetReader)tmp6);
            tmp1[1] = tmp4;
            SpreadSheetColumnFilter tmp7 = new SpreadSheetColumnFilter();
            argOption = (AbstractArgumentOption)tmp7.getOptionManager().findByProperty("finder");
            ByName tmp9 = new ByName();
            argOption = (AbstractArgumentOption)tmp9.getOptionManager().findByProperty("regExp");
            tmp9.setRegExp((BaseRegExp)argOption.valueOf(".*T.*"));
            tmp7.setCreateView(true);
            tmp7.setFinder((ColumnFinder)tmp9);
            tmp1[2] = tmp7;
            DumpFile tmp11 = new DumpFile();
            argOption = (AbstractArgumentOption)tmp11.getOptionManager().findByProperty("outputFile");
            tmp11.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.csv"));
            tmp1[3] = tmp11;
            flow.setActors(tmp1);
        }
        catch (Exception e) {
            SpreadSheetColumnFilterTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetColumnFilterTest.runTest((Test)SpreadSheetColumnFilterTest.suite());
    }
}

