/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.SpreadSheetColumnIterator;
import adams.flow.transformer.SpreadSheetFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetColumnIteratorTest
extends AbstractFlowTest {
    public SpreadSheetColumnIteratorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("iris.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("iris.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetColumnIteratorTest.class);
    }

    public Actor getActor() {
        Flow flow = new Flow();
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            Actor[] tmp1 = new Actor[4];
            FileSupplier tmp2 = new FileSupplier();
            argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("files");
            tmp2.setFiles(new PlaceholderFile[]{(PlaceholderFile)argOption.valueOf("${TMP}/iris.csv")});
            tmp1[0] = tmp2;
            SpreadSheetFileReader tmp4 = new SpreadSheetFileReader();
            argOption = (AbstractArgumentOption)tmp4.getOptionManager().findByProperty("reader");
            CsvSpreadSheetReader tmp6 = new CsvSpreadSheetReader();
            tmp4.setReader((SpreadSheetReader)tmp6);
            tmp1[1] = tmp4;
            SpreadSheetColumnIterator tmp7 = new SpreadSheetColumnIterator();
            tmp1[2] = tmp7;
            DumpFile tmp8 = new DumpFile();
            tmp8.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
            tmp8.setAppend(true);
            tmp1[3] = tmp8;
            flow.setActors(tmp1);
        }
        catch (Exception e) {
            SpreadSheetColumnIteratorTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetColumnIteratorTest.runTest((Test)SpreadSheetColumnIteratorTest.suite());
    }
}

