/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Range;
import adams.core.base.BaseRegExp;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.ArrayProcess;
import adams.flow.control.Flow;
import adams.flow.control.Tee;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.SpreadSheetCommonIDs;
import adams.flow.transformer.SpreadSheetFileReader;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetCommonIDsTest
extends AbstractFlowTest {
    public SpreadSheetCommonIDsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("iris_with_id-subset1.csv");
        this.m_TestHelper.copyResourceToTmp("iris_with_id-subset2.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile1.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile2.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("iris_with_id-subset1.csv");
        this.m_TestHelper.deleteFileFromTmp("iris_with_id-subset2.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile1.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile2.csv");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile1.csv"), new TmpFile("dumpfile2.csv")});
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetCommonIDsTest.class);
    }

    public Actor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            filesupplier.setOutputArray(true);
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/iris_with_id-subset1.csv"));
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/iris_with_id-subset2.csv"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors.add(filesupplier);
            ArrayProcess arrayprocess = new ArrayProcess();
            ArrayList<SpreadSheetFileReader> actors2 = new ArrayList<SpreadSheetFileReader>();
            SpreadSheetFileReader spreadsheetfilereader = new SpreadSheetFileReader();
            CsvSpreadSheetReader csvspreadsheetreader = new CsvSpreadSheetReader();
            DenseDataRow densedatarow = new DenseDataRow();
            csvspreadsheetreader.setDataRowType((DataRow)densedatarow);
            DefaultSpreadSheet spreadsheet = new DefaultSpreadSheet();
            csvspreadsheetreader.setSpreadSheetType((SpreadSheet)spreadsheet);
            argOption = (AbstractArgumentOption)csvspreadsheetreader.getOptionManager().findByProperty("missingValue");
            csvspreadsheetreader.setMissingValue((BaseRegExp)argOption.valueOf(""));
            argOption = (AbstractArgumentOption)csvspreadsheetreader.getOptionManager().findByProperty("textColumns");
            csvspreadsheetreader.setTextColumns((Range)argOption.valueOf("1,last"));
            spreadsheetfilereader.setReader((SpreadSheetReader)csvspreadsheetreader);
            actors2.add(spreadsheetfilereader);
            arrayprocess.setActors(actors2.toArray(new Actor[0]));
            actors.add(arrayprocess);
            Tee tee = new Tee();
            argOption = (AbstractArgumentOption)tee.getOptionManager().findByProperty("name");
            tee.setName((String)argOption.valueOf("common"));
            ArrayList<Object> actors3 = new ArrayList<Object>();
            SpreadSheetCommonIDs spreadsheetcommonids = new SpreadSheetCommonIDs();
            actors3.add(spreadsheetcommonids);
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile1.csv"));
            actors3.add(dumpfile);
            tee.setActors(actors3.toArray(new Actor[0]));
            actors.add(tee);
            Tee tee2 = new Tee();
            argOption = (AbstractArgumentOption)tee2.getOptionManager().findByProperty("name");
            tee2.setName((String)argOption.valueOf("not in common"));
            ArrayList<Object> actors4 = new ArrayList<Object>();
            SpreadSheetCommonIDs spreadsheetcommonids2 = new SpreadSheetCommonIDs();
            spreadsheetcommonids2.setInvert(true);
            actors4.add(spreadsheetcommonids2);
            DumpFile dumpfile2 = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile2.getOptionManager().findByProperty("outputFile");
            dumpfile2.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile2.csv"));
            actors4.add(dumpfile2);
            tee2.setActors(actors4.toArray(new Actor[0]));
            actors.add(tee2);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            SpreadSheetCommonIDsTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetCommonIDsTest.runTest((Test)SpreadSheetCommonIDsTest.suite());
    }
}

