/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.matrixstatistic.AbstractMatrixStatistic;
import adams.data.spreadsheet.matrixstatistic.Max;
import adams.data.spreadsheet.matrixstatistic.Mean;
import adams.data.spreadsheet.matrixstatistic.Median;
import adams.data.spreadsheet.matrixstatistic.Min;
import adams.data.spreadsheet.matrixstatistic.Missing;
import adams.data.spreadsheet.matrixstatistic.MultiMatrixStatistic;
import adams.data.spreadsheet.matrixstatistic.StandardDeviation;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.SpreadSheetFileWriter;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.SpreadSheetFileReader;
import adams.flow.transformer.SpreadSheetMatrixStatistic;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetMatrixStatisticTest
extends AbstractFlowTest {
    public SpreadSheetMatrixStatisticTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.csv")});
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetMatrixStatisticTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/bolts.csv"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors.add(filesupplier);
            SpreadSheetFileReader spreadsheetfilereader = new SpreadSheetFileReader();
            CsvSpreadSheetReader csvspreadsheetreader = new CsvSpreadSheetReader();
            DenseDataRow densedatarow = new DenseDataRow();
            csvspreadsheetreader.setDataRowType((DataRow)densedatarow);
            DefaultSpreadSheet defaultspreadsheet = new DefaultSpreadSheet();
            csvspreadsheetreader.setSpreadSheetType((SpreadSheet)defaultspreadsheet);
            spreadsheetfilereader.setReader((SpreadSheetReader)csvspreadsheetreader);
            actors.add(spreadsheetfilereader);
            SpreadSheetMatrixStatistic spreadsheetmatrixstatistic = new SpreadSheetMatrixStatistic();
            MultiMatrixStatistic multimatrixstatistic = new MultiMatrixStatistic();
            ArrayList<Object> statistics = new ArrayList<Object>();
            Max max = new Max();
            statistics.add(max);
            Mean mean = new Mean();
            statistics.add(mean);
            Median median = new Median();
            statistics.add(median);
            Min min = new Min();
            statistics.add(min);
            Missing missing = new Missing();
            statistics.add(missing);
            StandardDeviation standarddeviation = new StandardDeviation();
            statistics.add(standarddeviation);
            multimatrixstatistic.setStatistics(statistics.toArray(new AbstractMatrixStatistic[0]));
            spreadsheetmatrixstatistic.setStatistic((AbstractMatrixStatistic)multimatrixstatistic);
            actors.add(spreadsheetmatrixstatistic);
            SpreadSheetFileWriter spreadsheetfilewriter = new SpreadSheetFileWriter();
            argOption = (AbstractArgumentOption)spreadsheetfilewriter.getOptionManager().findByProperty("outputFile");
            spreadsheetfilewriter.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.csv"));
            CsvSpreadSheetWriter csvspreadsheetwriter = new CsvSpreadSheetWriter();
            csvspreadsheetwriter.setNumberFormat("#.######");
            spreadsheetfilewriter.setWriter((SpreadSheetWriter)csvspreadsheetwriter);
            actors.add(spreadsheetfilewriter);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            SpreadSheetMatrixStatisticTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetMatrixStatisticTest.runTest((Test)SpreadSheetMatrixStatisticTest.suite());
    }
}

