/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Range;
import adams.data.DateFormatString;
import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.SpreadSheetStringColumnToTime;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.env.Environment;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetStringColumnToTimeTest
extends AbstractConversionTestCase {
    public SpreadSheetStringColumnToTimeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("time.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("time.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        Object[] result;
        TmpFile file = new TmpFile("time.csv");
        try {
            CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
            reader.setTextColumns(new Range("first-last"));
            result = new SpreadSheet[]{reader.read((File)file)};
        }
        catch (Exception e) {
            result = new SpreadSheet[]{};
            SpreadSheetStringColumnToTimeTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        SpreadSheetStringColumnToTime[] result = new SpreadSheetStringColumnToTime[2];
        result[0] = new SpreadSheetStringColumnToTime();
        result[0].setColumn(new SpreadSheetColumnIndex("2"));
        result[0].setFormat(new DateFormatString("HH:mm"));
        result[1] = new SpreadSheetStringColumnToTime();
        result[1].setColumn(new SpreadSheetColumnIndex("3"));
        result[1].setFormat(new DateFormatString("K:mm a"));
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetStringColumnToTimeTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetStringColumnToTimeTest.runTest((Test)SpreadSheetStringColumnToTimeTest.suite());
    }
}

