/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetHelper;
import java.util.HashMap;
import java.util.Map;

public class SpreadSheetToNumeric
extends AbstractConversion {
    private static final long serialVersionUID = 4890225060389916155L;
    protected boolean m_ReplaceMissingCells;
    protected double m_MissingValue;
    protected double m_Unhandled;

    public String globalInfo() {
        return "Turns a spreadsheet into a purely numeric one.\nMissing cells can get replaced with a specified value or skipped.\nBooleans gets turned into 0/1 (false/true).\nDate/time types get turned into numeric ones by using their Java epoch.\nStrings (per column) get a 0-based index assigned in the order they appear.\nAny other cell type get flagged as missing or, if provided, set to the unhandled value.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("replace-missing-cells", "replaceMissingCells", (Object)false);
        this.m_OptionManager.add("missing-value", "missingValue", (Object)Double.NaN);
        this.m_OptionManager.add("unhandled", "unhandled", (Object)Double.NaN);
    }

    public void setReplaceMissingCells(boolean value) {
        this.m_ReplaceMissingCells = value;
        this.reset();
    }

    public boolean getReplaceMissingCells() {
        return this.m_ReplaceMissingCells;
    }

    public String replaceMissingCellsTipText() {
        return "If enabled, missing cells get replaced with the specified value.";
    }

    public void setMissingValue(double value) {
        this.m_MissingValue = value;
        this.reset();
    }

    public double getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The writer setup to use for generating the string.";
    }

    public void setUnhandled(double value) {
        this.m_Unhandled = value;
        this.reset();
    }

    public double getUnhandled() {
        return this.m_Unhandled;
    }

    public String unhandledTipText() {
        return "The replacement value for unhandled cell types.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"unhandled", (Object)this.m_Unhandled, (String)"unhandled: ");
        if (this.m_ReplaceMissingCells) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"missingValue", (Object)this.m_MissingValue, (String)", missing:");
        }
        return result;
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        return SpreadSheetHelper.convertToNumeric((SpreadSheet)this.m_Input, new HashMap<Integer, Map<String, Integer>>(), this.m_ReplaceMissingCells ? Double.valueOf(this.m_MissingValue) : null, this.m_Unhandled);
    }
}

