/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractMatrixToSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;

public class StringMatrixToSpreadSheet
extends AbstractMatrixToSpreadSheet {
    private static final long serialVersionUID = -2047404866165517428L;
    protected boolean m_ForceString;

    public String globalInfo() {
        return "Converts a string matrix into a SpreadSheet object.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("force-string", "forceString", (Object)false);
    }

    public void setForceString(boolean value) {
        this.m_ForceString = value;
        this.reset();
    }

    public boolean getForceString() {
        return this.m_ForceString;
    }

    public String forceStringTipText() {
        return "If enabled, the value is set as string, even if it resembles a number.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"forceString", (boolean)this.m_ForceString, (String)"force string", (String)"");
    }

    public Class accepts() {
        return String[][].class;
    }

    protected Object doConvert() throws Exception {
        int i;
        SpreadSheet result = this.newInstance();
        String[][] matrix = (String[][])this.getInput();
        HeaderRow row = result.getHeaderRow();
        for (i = 0; i < matrix[0].length; ++i) {
            row.addCell("" + (i + 1)).setContent("col-" + (i + 1));
        }
        for (int n = 0; n < matrix.length; ++n) {
            row = result.addRow("" + (n + 1));
            for (i = 0; i < matrix[0].length; ++i) {
                if (this.m_ForceString) {
                    row.addCell("" + (i + 1)).setContentAsString(matrix[n][i]);
                    continue;
                }
                row.addCell("" + (i + 1)).setContent(matrix[n][i]);
            }
        }
        return result;
    }
}

