/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.BasicDateTimeType;
import adams.core.Range;
import adams.core.base.BaseCharset;
import adams.core.base.BaseInteger;
import adams.core.base.BaseRegExp;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.management.OptionHandlingLocaleSupporter;
import adams.data.DateFormatString;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.input.AbstractSpreadSheetReaderWithMissingValueSupport;
import adams.data.io.input.NoHeaderSpreadSheetReader;
import adams.data.io.input.WindowedSpreadSheetReader;
import adams.data.io.output.FixedTabularSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Locale;
import java.util.TimeZone;

public class FixedTabularSpreadSheetReader
extends AbstractSpreadSheetReaderWithMissingValueSupport
implements OptionHandlingLocaleSupporter,
NoHeaderSpreadSheetReader,
WindowedSpreadSheetReader {
    private static final long serialVersionUID = 2446979875221254720L;
    protected BaseInteger[] m_ColumnWidth;
    protected Range m_TextColumns;
    protected Range m_DateTimeColumns;
    protected DateFormatString m_DateTimeFormat;
    protected boolean m_DateTimeLenient;
    protected BasicDateTimeType m_DateTimeType;
    protected TimeZone m_TimeZone;
    protected Locale m_Locale;
    protected boolean m_NoHeader;
    protected String m_CustomColumnHeaders;
    protected boolean m_Trim;
    protected int m_FirstRow;
    protected int m_NumRows;

    public String globalInfo() {
        return "Reads CSV files.\nIt is possible to force columns to be text. In that case no intelligent parsing is attempted to determine the type of data a cell has.\nFor very large files, one can turn on chunking, which returns spreadsheet objects till all the data has been read.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset());
        this.m_OptionManager.add("column-width", "columnWidth", (Object)new BaseInteger[]{new BaseInteger(Integer.valueOf(10))});
        this.m_OptionManager.add("trim", "trim", (Object)false);
        this.m_OptionManager.add("text-columns", "textColumns", (Object)new Range());
        this.m_OptionManager.add("datetime-columns", "dateTimeColumns", (Object)new Range());
        this.m_OptionManager.add("datetime-format", "dateTimeFormat", (Object)new DateFormatString("yyyy-MM-dd HH:mm:ss"));
        this.m_OptionManager.add("datetime-lenient", "dateTimeLenient", (Object)false);
        this.m_OptionManager.add("datetime-type", "dateTimeType", (Object)BasicDateTimeType.DATE_TIME);
        this.m_OptionManager.add("no-header", "noHeader", (Object)false);
        this.m_OptionManager.add("custom-column-headers", "customColumnHeaders", (Object)"");
        this.m_OptionManager.add("first-row", "firstRow", (Object)1, (Number)1, null);
        this.m_OptionManager.add("num-rows", "numRows", (Object)-1, (Number)-1, null);
    }

    public void setColumnWidth(BaseInteger[] value) {
        this.m_ColumnWidth = value;
        this.reset();
    }

    public BaseInteger[] getColumnWidth() {
        return this.m_ColumnWidth;
    }

    public String columnWidthTipText() {
        return "The width in characters to use for the columns; if only one is specified then this is used for all columns.";
    }

    protected BaseRegExp getDefaultMissingValue() {
        return new BaseRegExp("");
    }

    public void setTextColumns(Range value) {
        this.m_TextColumns = value;
        this.reset();
    }

    public Range getTextColumns() {
        return this.m_TextColumns;
    }

    public String textColumnsTipText() {
        return "The range of columns to treat as text.";
    }

    public void setDateTimeColumns(Range value) {
        this.m_DateTimeColumns = value;
        this.reset();
    }

    public Range getDateTimeColumns() {
        return this.m_DateTimeColumns;
    }

    public String dateTimeColumnsTipText() {
        return "The range of columns to treat as date/time msec.";
    }

    public void setDateTimeFormat(DateFormatString value) {
        this.m_DateTimeFormat = value;
        this.reset();
    }

    public DateFormatString getDateTimeFormat() {
        return this.m_DateTimeFormat;
    }

    public String dateTimeFormatTipText() {
        return "The format for date/time msecs.";
    }

    public void setDateTimeLenient(boolean value) {
        this.m_DateTimeLenient = value;
        this.reset();
    }

    public boolean isDateTimeLenient() {
        return this.m_DateTimeLenient;
    }

    public String dateTimeLenientTipText() {
        return "Whether date/time msec parsing is lenient or not.";
    }

    public void setDateTimeType(BasicDateTimeType value) {
        this.m_DateTimeType = value;
        this.reset();
    }

    public BasicDateTimeType getDateTimeType() {
        return this.m_DateTimeType;
    }

    public String dateTimeTypeTipText() {
        return "How to interpret the date/time data.";
    }

    public void setTimeZone(TimeZone value) {
        this.m_TimeZone = value;
        this.reset();
    }

    public TimeZone getTimeZone() {
        return this.m_TimeZone;
    }

    public String timeZoneTipText() {
        return "The time zone to use for interpreting dates/times; default is the system-wide defined one.";
    }

    public void setLocale(Locale value) {
        this.m_Locale = value;
        this.reset();
    }

    public Locale getLocale() {
        return this.m_Locale;
    }

    public String localeTipText() {
        return "The locale to use for parsing the numbers.";
    }

    public void setNoHeader(boolean value) {
        this.m_NoHeader = value;
        this.reset();
    }

    public boolean getNoHeader() {
        return this.m_NoHeader;
    }

    public String noHeaderTipText() {
        return "If enabled, all rows get added as data rows and a dummy header will get inserted.";
    }

    public void setCustomColumnHeaders(String value) {
        this.m_CustomColumnHeaders = value;
        this.reset();
    }

    public String getCustomColumnHeaders() {
        return this.m_CustomColumnHeaders;
    }

    public String customColumnHeadersTipText() {
        return "The custom headers to use for the columns instead (comma-separated list); ignored if empty.";
    }

    public void setTrim(boolean value) {
        this.m_Trim = value;
        this.reset();
    }

    public boolean getTrim() {
        return this.m_Trim;
    }

    public String trimTipText() {
        return "If enabled, the content of the cells gets trimmed before added.";
    }

    public void setFirstRow(int value) {
        if (this.getOptionManager().isValid("firstRow", (Number)value)) {
            this.m_FirstRow = value;
            this.reset();
        }
    }

    public int getFirstRow() {
        return this.m_FirstRow;
    }

    public String firstRowTipText() {
        return "The index of the first row to retrieve (1-based).";
    }

    public void setNumRows(int value) {
        this.m_NumRows = value < 0 ? -1 : value;
        this.reset();
    }

    public int getNumRows() {
        return this.m_NumRows;
    }

    public String numRowsTipText() {
        return "The number of data rows to retrieve; use -1 for unlimited.";
    }

    public String getFormatDescription() {
        return new FixedTabularSpreadSheetWriter().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new FixedTabularSpreadSheetWriter().getFormatExtensions();
    }

    public SpreadSheetWriter getCorrespondingWriter() {
        return new FixedTabularSpreadSheetWriter();
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.READER;
    }

    protected boolean supportsCompressedInput() {
        return true;
    }

    protected SpreadSheet doRead(Reader r) {
        String[] cells;
        int i;
        SpreadSheet result = this.m_SpreadSheetType.newInstance();
        result.setDataRowClass(this.getDataRowType().getClass());
        HeaderRow row = result.getHeaderRow();
        if (this.m_NoHeader) {
            if (!this.m_CustomColumnHeaders.isEmpty()) {
                String[] custom = this.m_CustomColumnHeaders.split(",");
                if (this.m_ColumnWidth.length != custom.length) {
                    throw new IllegalStateException("Number of Column widths and custom headers differ: " + this.m_ColumnWidth.length + " != " + custom.length);
                }
                for (i = 0; i < this.m_ColumnWidth.length; ++i) {
                    row.addCell("" + i).setContentAsString(custom[i]);
                }
            } else {
                cells = SpreadSheetUtils.createHeader((int)this.m_ColumnWidth.length, (String)"").toArray(new String[0]);
                for (i = 0; i < cells.length; ++i) {
                    row.addCell("" + i).setContentAsString(cells[i]);
                }
            }
        } else {
            for (i = 0; i < this.m_ColumnWidth.length; ++i) {
                row.addCell("" + i);
            }
        }
        Cell.ContentType[] types = new Cell.ContentType[this.m_ColumnWidth.length];
        this.m_TextColumns.setMax(this.m_ColumnWidth.length);
        this.m_DateTimeColumns.setMax(this.m_ColumnWidth.length);
        block16: for (i = 0; i < this.m_ColumnWidth.length; ++i) {
            types[i] = null;
            if (this.m_TextColumns.isInRange(i)) {
                types[i] = Cell.ContentType.STRING;
                continue;
            }
            if (!this.m_DateTimeColumns.isInRange(i)) continue;
            switch (this.m_DateTimeType) {
                case TIME: {
                    types[i] = Cell.ContentType.TIME;
                    continue block16;
                }
                case TIME_MSEC: {
                    types[i] = Cell.ContentType.TIMEMSEC;
                    continue block16;
                }
                case DATE: {
                    types[i] = Cell.ContentType.DATE;
                    continue block16;
                }
                case DATE_TIME: {
                    types[i] = Cell.ContentType.DATETIME;
                    continue block16;
                }
                case DATE_TIME_MSEC: {
                    types[i] = Cell.ContentType.DATETIMEMSEC;
                    continue block16;
                }
                default: {
                    throw new IllegalStateException("Unhandled date/time type: " + this.m_DateTimeType);
                }
            }
        }
        int[] cols = new int[this.m_ColumnWidth.length + 1];
        for (i = 0; i < this.m_ColumnWidth.length; ++i) {
            cols[i + 1] = cols[i] + this.m_ColumnWidth[i].intValue();
        }
        BufferedReader reader = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        try {
            String line;
            boolean first = true;
            cells = new String[this.m_ColumnWidth.length];
            int count = -1;
            int firstRow = this.m_FirstRow - 1;
            int lastRow = this.m_NumRows > 0 ? firstRow + this.m_NumRows - 1 : -1;
            while ((line = reader.readLine()) != null) {
                if (++count < firstRow) continue;
                if (lastRow > -1 && count > lastRow) break;
                for (i = 0; i < cols.length - 1; ++i) {
                    cells[i] = line.substring(cols[i], cols[i + 1]);
                    if (!this.m_Trim) continue;
                    cells[i] = cells[i].trim();
                }
                if (!this.m_NoHeader && first) {
                    first = false;
                    row = result.getHeaderRow();
                    for (i = 0; i < cells.length; ++i) {
                        row.getCell(i).setContentAsString(cells[i]);
                    }
                    continue;
                }
                row = result.addRow();
                block21: for (i = 0; i < cells.length; ++i) {
                    Cell cell = row.addCell(i);
                    if (this.m_MissingValue.isMatch(cells[i]) || cells[i].isEmpty() && this.m_MissingValue.isEmpty()) {
                        cell.setMissing();
                        continue;
                    }
                    if (types[i] == null) {
                        cell.setContent(cells[i]);
                        continue;
                    }
                    switch (types[i]) {
                        case STRING: {
                            cell.setContentAsString(cells[i]);
                            continue block21;
                        }
                        case TIME: 
                        case TIMEMSEC: 
                        case DATE: 
                        case DATETIME: 
                        case DATETIMEMSEC: {
                            cell.setNative(cell.parseContent(cells[i], types[i]));
                            continue block21;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled cell type: " + types[i]);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.m_LastError = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to read data!", (Throwable)e);
            return null;
        }
        return result;
    }
}

