/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.core.AbstractDataBackedUnorderedRange;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;

public class SpreadSheetUnorderedColumnRange
extends AbstractDataBackedUnorderedRange<SpreadSheet> {
    private static final long serialVersionUID = 5215987200366396733L;

    public SpreadSheetUnorderedColumnRange() {
    }

    public SpreadSheetUnorderedColumnRange(String range) {
        super(range);
    }

    public SpreadSheetUnorderedColumnRange(String range, int max) {
        super(range, max);
    }

    public void setSpreadSheet(SpreadSheet value) {
        this.setData(value);
    }

    public SpreadSheet getSpreadSheet() {
        return (SpreadSheet)this.getData();
    }

    public SpreadSheetUnorderedColumnRange getClone() {
        return (SpreadSheetUnorderedColumnRange)super.getClone();
    }

    protected int getNumNames(SpreadSheet data) {
        return data.getColumnCount();
    }

    protected String getName(SpreadSheet data, int colIndex) {
        return data.getHeaderRow().getCell(colIndex).getContent();
    }

    protected int[] parseSubRange(String subrange) {
        SpreadSheetColumnRange range = new SpreadSheetColumnRange(subrange);
        if (this.m_Data == null) {
            range.setMax(this.m_Max);
        } else {
            range.setData(this.m_Data);
        }
        return range.getIntIndices();
    }

    public String getExample() {
        return "A range is a comma-separated list of single 1-based indices or sub-ranges of indices ('start-end'); column names (case-sensitive) as well as the following placeholders can be used: first, second, third, last_2, last_1, last; numeric indices can be enforced by preceding them with '#' (eg '#12'); column names can be surrounded by double quotes.";
    }
}

