/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.colstatistic;

import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.colstatistic.AbstractDoubleArrayColumnStatistic;

public class Percentile
extends AbstractDoubleArrayColumnStatistic {
    private static final long serialVersionUID = -4468456504069465058L;
    protected double m_Percentile;

    public String globalInfo() {
        return "Calculates the specified percentile.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("percentile", "percentile", (Object)0.25, (Number)0.0, (Number)1.0);
    }

    public void setPercentile(double value) {
        this.m_Percentile = value;
        this.reset();
    }

    public double getPercentile() {
        return this.m_Percentile;
    }

    public String percentileTipText() {
        return "The percentile to use (0-1).";
    }

    @Override
    protected SpreadSheet postVisit(SpreadSheet sheet, int colIndex) {
        SpreadSheet result = this.createOutputHeader();
        adams.data.statistics.Percentile perc = new adams.data.statistics.Percentile();
        for (int i = 0; i < this.m_Values.size(); ++i) {
            perc.add((Comparable)Double.valueOf(this.m_Values.get(i)));
        }
        DataRow row = result.addRow();
        row.addCell(0).setContent("Percentile (" + this.m_Percentile + ")");
        row.addCell(1).setContent((Double)perc.getPercentile(this.m_Percentile));
        this.m_Values = null;
        return result;
    }
}

