/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.filter;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.filter.AbstractSpreadSheetFilter;
import adams.data.spreadsheet.filter.TrainableSpreadSheetFilter;

public abstract class AbstractTrainableSpreadSheetFilter
extends AbstractSpreadSheetFilter
implements TrainableSpreadSheetFilter {
    private static final long serialVersionUID = 3614769696656146304L;
    protected boolean m_Trained;

    @Override
    public void resetFilter() {
        this.m_Trained = false;
    }

    @Override
    public boolean isTrained() {
        return this.m_Trained;
    }

    protected String checkTrain(SpreadSheet data) {
        if (data == null) {
            return "No training spreadsheet provided!";
        }
        return null;
    }

    protected abstract SpreadSheet doTrain(SpreadSheet var1) throws Exception;

    @Override
    public SpreadSheet train(SpreadSheet data) throws Exception {
        String msg = this.checkTrain(data);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        SpreadSheet result = this.doTrain(data);
        this.m_Trained = true;
        return result;
    }

    @Override
    public SpreadSheet filter(SpreadSheet data) throws Exception {
        if (!this.isTrained()) {
            return this.train(data);
        }
        return super.filter(data);
    }
}

