/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.matrixstatistic;

import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.matrixstatistic.AbstractMatrixStatistic;
import adams.data.statistics.StatUtils;

public class StandardDeviation
extends AbstractMatrixStatistic {
    private static final long serialVersionUID = 330391755072250767L;
    protected boolean m_IsSample;

    public String globalInfo() {
        return "Determines the standard deviation of the numeric values in the matrix, skips NaN and infinite values.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("is-sample", "isSample", (Object)true);
    }

    public void setIsSample(boolean value) {
        this.m_IsSample = value;
        this.reset();
    }

    public boolean getIsSample() {
        return this.m_IsSample;
    }

    public String isSampleTipText() {
        return "If set to true, the data is treated as sample and not as population.";
    }

    @Override
    protected SpreadSheet doGenerate(SpreadSheet sheet) {
        SpreadSheet result = this.createOutputHeader();
        DataRow row = result.addRow();
        row.addCell(0).setContent("StdDev" + (this.getIsSample() ? "" : "P"));
        row.addCell(1).setContent(Double.valueOf(StatUtils.stddev((double[])this.getNumericValues(sheet).toArray(), (boolean)this.m_IsSample)));
        return result;
    }
}

