/*
 * Decompiled with CFR 0.152.
 */
package adams.data.textrenderer;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetView;
import adams.data.textrenderer.AbstractLimitedTextRenderer;
import gnu.trove.list.array.TIntArrayList;
import nz.ac.waikato.cms.locator.ClassLocator;

public class SpreadSheetTextRenderer
extends AbstractLimitedTextRenderer {
    private static final long serialVersionUID = 2413293721997389467L;

    public String globalInfo() {
        return "Renders spreadsheet as CSV up to the specified maximum of rows.";
    }

    protected int getDefaultLimit() {
        return 100;
    }

    protected Integer getMinLimit() {
        return 0;
    }

    protected Integer getMaxLimit() {
        return null;
    }

    public String limitTipText() {
        return "The maximum number of rows to render.";
    }

    public boolean handles(Object obj) {
        return obj instanceof SpreadSheet;
    }

    public boolean handles(Class cls) {
        return ClassLocator.matches(SpreadSheet.class, (Class)cls);
    }

    protected String doRender(Object obj) {
        SpreadSheet sheet = (SpreadSheet)obj;
        if (sheet.getRowCount() > this.getActualLimit()) {
            TIntArrayList rows = new TIntArrayList();
            for (int i = 0; i < this.m_Limit; ++i) {
                rows.add(i);
            }
            sheet = new SpreadSheetView(sheet, rows.toArray(), null);
        }
        StringBuilder result = new StringBuilder(sheet.toString());
        if (sheet.getRowCount() > this.getActualLimit()) {
            result.append("...");
        }
        return result.toString();
    }
}

