/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.io.output.AbstractImageWriter;
import adams.data.io.output.JAIImageWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.sink.AbstractFileWriter;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.jfreechart.chart.AbstractChartGenerator;
import adams.gui.visualization.jfreechart.chart.XYLineChart;
import adams.gui.visualization.jfreechart.dataset.AbstractDatasetGenerator;
import adams.gui.visualization.jfreechart.dataset.ChartUtils;
import adams.gui.visualization.jfreechart.dataset.DefaultXY;
import adams.gui.visualization.jfreechart.shape.AbstractShapeGenerator;
import adams.gui.visualization.jfreechart.shape.Default;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.general.Dataset;

public class JFreeChartFileWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = -2648121220428217287L;
    protected AbstractDatasetGenerator m_Dataset;
    protected AbstractChartGenerator m_Chart;
    protected AbstractShapeGenerator m_Shape;
    protected Color m_PlotColor;
    protected ColorProvider m_ColorProvider;
    protected Color m_DiagonalColor;
    protected int m_Width;
    protected int m_Height;
    protected AbstractImageWriter m_Writer;

    public String globalInfo() {
        return "Generates a JFreeChart plot and writes the bitmap to a file.\nDataset generation is skipped if the incoming data already represents a JFreeChart dataset.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("dataset", "dataset", (Object)new DefaultXY());
        this.m_OptionManager.add("chart", "chart", (Object)new XYLineChart());
        this.m_OptionManager.add("shape", "shape", (Object)new Default());
        this.m_OptionManager.add("plot-color", "plotColor", (Object)Color.BLUE);
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)new DefaultColorProvider());
        this.m_OptionManager.add("diagonal-color", "diagonalColor", (Object)Color.BLACK);
        this.m_OptionManager.add("width", "width", (Object)800, (Number)-1, null);
        this.m_OptionManager.add("height", "height", (Object)600, (Number)-1, null);
        this.m_OptionManager.add("writer", "writer", (Object)new JAIImageWriter());
    }

    public String outputFileTipText() {
        return "The file to write the plot to";
    }

    public void setDataset(AbstractDatasetGenerator value) {
        this.m_Dataset = value;
        this.reset();
    }

    public AbstractDatasetGenerator getDataset() {
        return this.m_Dataset;
    }

    public String datasetTipText() {
        return "The dataset generator to use.";
    }

    public void setChart(AbstractChartGenerator value) {
        this.m_Chart = value;
        this.reset();
    }

    public AbstractChartGenerator getChart() {
        return this.m_Chart;
    }

    public String chartTipText() {
        return "The chart generator to use.";
    }

    public void setShape(AbstractShapeGenerator value) {
        this.m_Shape = value;
        this.reset();
    }

    public AbstractShapeGenerator getShape() {
        return this.m_Shape;
    }

    public String shapeTipText() {
        return "The shape generator to use for the data point markers.";
    }

    public void setPlotColor(Color value) {
        this.m_PlotColor = value;
        this.reset();
    }

    public Color getPlotColor() {
        return this.m_PlotColor;
    }

    public String plotColorTipText() {
        return "The color for the plot.";
    }

    public void setColorProvider(ColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public ColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider to use for coloring in the trimap image.";
    }

    public void setDiagonalColor(Color value) {
        this.m_DiagonalColor = value;
        this.reset();
    }

    public Color getDiagonalColor() {
        return this.m_DiagonalColor;
    }

    public String diagonalColorTipText() {
        return "The color for the diagonal (ie second data series if present).";
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the plot.";
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the plot.";
    }

    public void setWriter(AbstractImageWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public AbstractImageWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The image writer to use.";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class, Dataset.class};
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"dataset", (Object)((Object)this.m_Dataset), (String)", dataset: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"chart", (Object)((Object)this.m_Chart), (String)", chart: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"shape", (Object)((Object)this.m_Shape), (String)", shape: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"width", (Object)this.m_Width, (String)", width:");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"height", (Object)this.m_Height, (String)", height:");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"writer", (Object)this.m_Writer, (String)", writer: ");
        return result;
    }

    protected String doExecute() {
        String result = null;
        try {
            Object dataset;
            if (this.m_InputToken.hasPayload(SpreadSheet.class)) {
                SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
                dataset = this.m_Dataset.generate(sheet);
            } else {
                dataset = (Dataset)this.m_InputToken.getPayload(Dataset.class);
            }
            JFreeChart jfreechart = this.m_Chart.generate(dataset);
            Shape shape = this.m_Shape.generate();
            jfreechart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
            this.m_ColorProvider.resetColors();
            if (jfreechart.getPlot() instanceof XYPlot) {
                XYPlot plot = (XYPlot)jfreechart.getPlot();
                plot.setDomainGridlinesVisible(true);
                plot.setDomainGridlinePaint((Paint)Color.GRAY);
                plot.setRangeGridlinesVisible(true);
                plot.setRangeGridlinePaint((Paint)Color.GRAY);
                ChartUtils.applyColor(plot, this.m_PlotColor, this.m_DiagonalColor, this.m_ColorProvider);
                ChartUtils.applyShape(plot, shape);
            }
            BufferedImage image = jfreechart.createBufferedImage(this.m_Width, this.m_Height);
            BufferedImageContainer cont = new BufferedImageContainer();
            cont.setImage((Object)image);
            this.m_Writer.write(this.m_OutputFile, (AbstractImageContainer)cont);
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate plot!", e);
        }
        return result;
    }
}

