/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.LookUpHelper;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUpdater;
import adams.flow.transformer.AbstractSpreadSheetTransformer;
import java.util.HashMap;

public class LookUpInit
extends AbstractSpreadSheetTransformer
implements StorageUpdater {
    private static final long serialVersionUID = 4182914190162129217L;
    protected StorageName m_StorageName;
    protected SpreadSheetColumnIndex m_KeyColumn;
    protected SpreadSheetColumnIndex m_ValueColumn;
    protected boolean m_UseNative;

    public String globalInfo() {
        return "Creates a lookup table from a spreadsheet, using one column as key and another one as value. The lookup table itself gets stored in the internal storage under the specified name.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("lookup"));
        this.m_OptionManager.add("key-column", "keyColumn", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("value-column", "valueColumn", (Object)new SpreadSheetColumnIndex("2"));
        this.m_OptionManager.add("use-native", "useNative", (Object)false);
    }

    public boolean isUpdatingStorage() {
        return !this.getSkip();
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"storage: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"keyColumn", (Object)((Object)this.m_KeyColumn), (String)", key: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"valueColumn", (Object)((Object)this.m_ValueColumn), (String)", value: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"useNative", (boolean)this.m_UseNative, (String)", native");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name for the lookup table in the internal storage.";
    }

    public void setKeyColumn(SpreadSheetColumnIndex value) {
        this.m_KeyColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getKeyColumn() {
        return this.m_KeyColumn;
    }

    public String keyColumnTipText() {
        return "The index of the column in the spreadsheet to use as key; " + this.m_KeyColumn.getExample();
    }

    public void setValueColumn(SpreadSheetColumnIndex value) {
        this.m_ValueColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getValueColumn() {
        return this.m_ValueColumn;
    }

    public String valueColumnTipText() {
        return "The index of the column in the spreadsheet to use as value; " + this.m_ValueColumn.getExample();
    }

    public void setUseNative(boolean value) {
        this.m_UseNative = value;
        this.reset();
    }

    public boolean getUseNative() {
        return this.m_UseNative;
    }

    public String useNativeTipText() {
        return "If enabled, native objects are used as value rather than strings.";
    }

    protected String doExecute() {
        String result = this.getOptionManager().ensureVariableForPropertyExists("storageName");
        if (result == null) {
            SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
            StringBuilder error = new StringBuilder();
            HashMap<String, Object> lookup = LookUpHelper.load(sheet, this.m_KeyColumn.getIndex(), this.m_ValueColumn.getIndex(), this.m_UseNative, error);
            if (lookup == null) {
                result = error.toString();
            } else {
                this.getStorageHandler().getStorage().put(this.m_StorageName, lookup);
            }
        }
        if (result == null) {
            this.m_OutputToken = this.m_InputToken;
        }
        return result;
    }
}

