/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.matrixstatistic.AbstractMatrixStatistic;
import adams.data.spreadsheet.matrixstatistic.Max;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;

public class SpreadSheetMatrixStatistic
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = 4527040722924866539L;
    protected AbstractMatrixStatistic m_Statistic;

    public String globalInfo() {
        return "Generates statistics for the spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("statistic", "statistic", (Object)new Max());
    }

    public void setStatistic(AbstractMatrixStatistic value) {
        this.m_Statistic = value;
        this.reset();
    }

    public AbstractMatrixStatistic getStatistic() {
        return this.m_Statistic;
    }

    public String statisticTipText() {
        return "The statistic to generate for the spreadsheet.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"statistic", (Object)((Object)this.m_Statistic), (String)"statistic: ");
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet input = (SpreadSheet)this.m_InputToken.getPayload();
        SpreadSheet output = this.m_Statistic.generate(input);
        if (this.m_Statistic.hasLastError()) {
            result = this.m_Statistic.getLastError();
        } else {
            this.m_OutputToken = new Token((Object)output);
        }
        return result;
    }
}

