/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.spreadsheetmethodmerge;

import adams.core.QuickInfoSupporter;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.base.BaseString;
import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.columnfinder.ColumnFinder;
import adams.data.spreadsheet.columnfinder.NullFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

public abstract class AbstractMerge
extends AbstractOptionHandler
implements QuickInfoSupporter {
    private static final long serialVersionUID = 6105022032625366441L;
    protected static final String SPREADSHEET_KEYWORD = "{SPREADSHEET}";
    protected static final int ROW_MISSING = -1;
    protected ColumnFinder m_ClassFinder;
    protected BaseString[] m_SpreadsheetNames;
    protected BaseRegExp[] m_ColumnRenameFindRegexs;
    protected BaseString[] m_ColumnRenameFormatStrings;
    protected String m_MergedSpreadsheetName;
    protected boolean m_EnsureEqualValues;
    protected SpreadSheet[] m_Spreadsheets;
    protected int[][] m_ClassColumns;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("class-finder", "classFinder", (Object)new NullFinder());
        this.m_OptionManager.add("spreadsheet-names", "spreadsheetNames", (Object)new BaseString[0]);
        this.m_OptionManager.add("column-renames-exp", "columnRenamesExp", (Object)new BaseRegExp[0]);
        this.m_OptionManager.add("column-renames-format", "columnRenamesFormat", (Object)new BaseString[0]);
        this.m_OptionManager.add("output-name", "outputName", (Object)"output");
        this.m_OptionManager.add("ensure-equal-values", "ensureEqualValues", (Object)false);
    }

    public ColumnFinder getClassFinder() {
        return this.m_ClassFinder;
    }

    public void setClassFinder(ColumnFinder value) {
        this.m_ClassFinder = value;
        this.reset();
    }

    public String classFinderTipText() {
        return "The method to use to find class columns in the spreadsheets.";
    }

    public BaseString[] getSpreadsheetNames() {
        return this.m_SpreadsheetNames;
    }

    public void setSpreadsheetNames(BaseString[] value) {
        if (value == null) {
            value = new BaseString[]{};
        }
        if (this.m_ColumnRenameFindRegexs != null && value.length < this.m_ColumnRenameFindRegexs.length) {
            BaseString[] expandedValue = new BaseString[this.m_ColumnRenameFindRegexs.length];
            for (int i = 0; i < this.m_ColumnRenameFindRegexs.length; ++i) {
                expandedValue[i] = i < value.length ? value[i] : new BaseString("Spreadsheet" + i);
            }
            value = expandedValue;
        }
        this.m_SpreadsheetNames = value;
        this.reset();
    }

    public String spreadsheetNamesTipText() {
        return "The list of spreadsheet names to use in column renaming.";
    }

    public BaseRegExp[] getColumnRenamesExp() {
        return this.m_ColumnRenameFindRegexs;
    }

    public void setColumnRenamesExp(BaseRegExp[] value) {
        this.m_ColumnRenameFindRegexs = value;
        this.setColumnRenamesFormat(this.m_ColumnRenameFormatStrings);
        this.setSpreadsheetNames(this.m_SpreadsheetNames);
        this.reset();
    }

    public String columnRenamesExpTipText() {
        return "The expressions to use to select column names for renaming (one per spreadsheet).";
    }

    public BaseString[] getColumnRenamesFormat() {
        return this.m_ColumnRenameFormatStrings;
    }

    public void setColumnRenamesFormat(BaseString[] value) {
        if (value == null) {
            value = new BaseString[]{};
        }
        if (this.m_ColumnRenameFindRegexs != null && value.length < this.m_ColumnRenameFindRegexs.length) {
            value = (BaseString[])Utils.adjustArray((Object)value, (int)this.m_ColumnRenameFindRegexs.length, (Object)new BaseString("$0"));
        }
        this.m_ColumnRenameFormatStrings = value;
        this.reset();
    }

    public String columnRenamesFormatTipText() {
        return "One format string for each renaming expression to specify how to rename the column. Can contain the {SPREADSHEET} keyword which will be replaced by the spreadsheet name, and also group identifiers which will be replaced by groups from the renaming regex.";
    }

    public String getOutputName() {
        return this.m_MergedSpreadsheetName;
    }

    public void setOutputName(String value) {
        this.m_MergedSpreadsheetName = value;
        this.reset();
    }

    public String outputNameTipText() {
        return "The name to use for the merged spreadsheet.";
    }

    public boolean getEnsureEqualValues() {
        return this.m_EnsureEqualValues;
    }

    public void setEnsureEqualValues(boolean value) {
        this.m_EnsureEqualValues = value;
        this.reset();
    }

    public String ensureEqualValuesTipText() {
        return "Whether multiple column being merged into a single column require equal values from all sources.";
    }

    public String getQuickInfo() {
        return null;
    }

    protected void setValue(DataRow toSet, int columnIndex, Object value) {
        if (toSet == null) {
            return;
        }
        toSet.getCell(columnIndex).setNative(value);
    }

    protected Object getValue(DataRow toGetFrom, int columnIndex) {
        if (toGetFrom == null) {
            return null;
        }
        return toGetFrom.getCell(columnIndex).getNative();
    }

    protected String check(SpreadSheet[] spreadsheets) {
        if (spreadsheets == null) {
            return "No spreadsheets to merge!";
        }
        if (spreadsheets.length < 2) {
            return "Require at least 2 spreadsheets to merge, but " + spreadsheets.length + " were provided.";
        }
        if (this.m_MergedSpreadsheetName.length() == 0) {
            return "Must provide a name for the output spreadsheet.";
        }
        if (this.m_SpreadsheetNames.length < this.m_ColumnRenameFindRegexs.length) {
            return "Not enough spreadsheet names supplied for column renaming (require " + this.m_ColumnRenameFindRegexs.length + ", have " + this.m_SpreadsheetNames.length + ").";
        }
        if (this.m_ColumnRenameFormatStrings.length < this.m_ColumnRenameFindRegexs.length) {
            return "Not enough format strings supplied for column renaming (require " + this.m_ColumnRenameFindRegexs.length + ", have " + this.m_ColumnRenameFormatStrings.length + ").";
        }
        return null;
    }

    protected String checkColumnMapping(Map<String, List<SourceColumn>> columnMapping) {
        return null;
    }

    public SpreadSheet merge(SpreadSheet[] spreadsheets) {
        this.resetInternalState(spreadsheets);
        String msg = this.check(spreadsheets);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        Map<String, List<SourceColumn>> columnMapping = this.createColumnMapping();
        msg = this.checkColumnMapping(columnMapping);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        SpreadSheet mergedSpreadsheet = this.createEmptyResultantSpreadsheet(columnMapping);
        Enumeration<int[]> rowSetEnumeration = this.getRowSetEnumeration();
        while (rowSetEnumeration.hasMoreElements()) {
            int[] rowSet = rowSetEnumeration.nextElement();
            DataRow mergedRow = mergedSpreadsheet.addRow();
            for (int columnIndex = 0; columnIndex < mergedSpreadsheet.getColumnCount(); ++columnIndex) {
                Object value;
                String column = mergedSpreadsheet.getColumnName(columnIndex);
                List<SourceColumn> sourceColumns = columnMapping.get(column);
                Object object = value = this.m_EnsureEqualValues ? this.getValueEnsureEqual(rowSet, sourceColumns) : this.getValueFirstAvailable(rowSet, sourceColumns);
                if (value == null) continue;
                this.setValue(mergedRow, columnIndex, value);
            }
        }
        return mergedSpreadsheet;
    }

    protected Object getValueFirstAvailable(int[] rowSet, List<SourceColumn> sourceColumnElements) {
        for (SourceColumn element : sourceColumnElements) {
            DataRow row;
            int rowIndex = rowSet[element.spreadsheetIndex];
            if (rowIndex == -1 || (row = this.m_Spreadsheets[element.spreadsheetIndex].getRow(rowIndex)).getCell(element.columnIndex).isMissing()) continue;
            return this.getValue(row, element.columnIndex);
        }
        return null;
    }

    protected Object getValueEnsureEqual(int[] rowSet, List<SourceColumn> sources) {
        Object value = null;
        SourceColumn valueElement = null;
        int valueRowIndex = -1;
        for (SourceColumn element : sources) {
            DataRow row;
            int rowIndex = rowSet[element.spreadsheetIndex];
            if (rowIndex == -1 || (row = this.m_Spreadsheets[element.spreadsheetIndex].getRow(rowIndex)).getCell(element.columnIndex).isMissing()) continue;
            Object currentValue = this.getValue(row, element.columnIndex);
            if (value == null) {
                value = currentValue;
                valueElement = element;
                valueRowIndex = rowIndex;
                continue;
            }
            if (value.equals(currentValue)) continue;
            throw new IllegalStateException("Merging columns have multiple different source values! (" + currentValue + " in " + this.m_SpreadsheetNames[element.spreadsheetIndex] + ", column " + element.columnName + ", row " + rowIndex + " instead of " + value + " in " + this.m_SpreadsheetNames[valueElement.spreadsheetIndex] + ", column " + valueElement.columnName + ", row " + valueRowIndex + ")");
        }
        return value;
    }

    protected Map<String, List<SourceColumn>> createColumnMapping() {
        HashMap<String, List<SourceColumn>> mapping = new HashMap<String, List<SourceColumn>>();
        for (int spreadsheetIndex = 0; spreadsheetIndex < this.m_Spreadsheets.length; ++spreadsheetIndex) {
            SpreadSheet spreadsheet = this.m_Spreadsheets[spreadsheetIndex];
            for (int columnIndex = 0; columnIndex < spreadsheet.getColumnCount(); ++columnIndex) {
                String columnName = spreadsheet.getColumnName(columnIndex);
                SourceColumn mappingElement = new SourceColumn(spreadsheetIndex, columnIndex, columnName);
                String mappedColumnName = this.getMappedColumnName(mappingElement);
                if (!mapping.containsKey(mappedColumnName)) {
                    mapping.put(mappedColumnName, new LinkedList());
                }
                ((List)mapping.get(mappedColumnName)).add(mappingElement);
            }
        }
        return mapping;
    }

    protected boolean isAnyClassColumn(List<SourceColumn> sources) {
        for (SourceColumn source : sources) {
            if (!this.isClassColumn(source)) continue;
            return true;
        }
        return false;
    }

    protected boolean isClassColumn(SourceColumn source) {
        return this.isClassColumn(source.spreadsheetIndex, source.columnIndex);
    }

    protected boolean isClassColumn(int spreadsheetIndex, int columnIndex) {
        if (this.m_ClassColumns == null) {
            this.recordClassColumns();
        }
        return Arrays.binarySearch(this.m_ClassColumns[spreadsheetIndex], columnIndex) >= 0;
    }

    protected void recordClassColumns() {
        this.m_ClassColumns = new int[this.m_Spreadsheets.length][];
        for (int i = 0; i < this.m_Spreadsheets.length; ++i) {
            SpreadSheet spreadsheet = this.m_Spreadsheets[i];
            int[] classColumns = this.m_ClassFinder.findColumns(spreadsheet);
            Arrays.sort(classColumns);
            this.m_ClassColumns[i] = classColumns;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected SpreadSheet createEmptyResultantSpreadsheet(Map<String, List<SourceColumn>> columnMapping) {
        void var6_12;
        LinkedList<List<SourceColumn>> orderingList = new LinkedList<List<SourceColumn>>();
        HashMap<List<SourceColumn>, String> columns = new HashMap<List<SourceColumn>, String>();
        for (String string : columnMapping.keySet()) {
            List<SourceColumn> list = columnMapping.get(string);
            columns.put(list, string);
            orderingList.add(list);
        }
        orderingList.sort(this::compare);
        ArrayList orderedColumns = new ArrayList(orderingList.size());
        for (List list : orderingList) {
            orderedColumns.add(columns.get(list));
        }
        DefaultSpreadSheet defaultSpreadSheet = new DefaultSpreadSheet();
        defaultSpreadSheet.setName(this.m_MergedSpreadsheetName);
        boolean bl = false;
        while (var6_12 < orderedColumns.size()) {
            defaultSpreadSheet.insertColumn((int)var6_12, (String)orderedColumns.get((int)var6_12));
            ++var6_12;
        }
        return defaultSpreadSheet;
    }

    protected int compare(List<SourceColumn> sources1, List<SourceColumn> sources2) {
        boolean className1 = this.isAnyClassColumn(sources1);
        boolean className2 = this.isAnyClassColumn(sources2);
        if (className1 && !className2) {
            return 1;
        }
        if (!className1 && className2) {
            return -1;
        }
        return sources1.get(0).compareTo(sources2.get(0));
    }

    protected String getMappedColumnName(SourceColumn source) {
        BaseRegExp renameRegex;
        Matcher columnNameMatcher;
        if (this.isClassColumn(source)) {
            return source.columnName;
        }
        if (source.spreadsheetIndex < this.m_ColumnRenameFindRegexs.length && (columnNameMatcher = (renameRegex = this.m_ColumnRenameFindRegexs[source.spreadsheetIndex]).patternValue().matcher(source.columnName)).matches()) {
            String mappedString = this.m_ColumnRenameFormatStrings[source.spreadsheetIndex].stringValue();
            mappedString = mappedString.replace(SPREADSHEET_KEYWORD, this.m_SpreadsheetNames[source.spreadsheetIndex].stringValue());
            for (int groupIndex = columnNameMatcher.groupCount(); groupIndex >= 0; --groupIndex) {
                String groupMatch = columnNameMatcher.group(groupIndex);
                mappedString = mappedString.replace("$" + groupIndex, groupMatch);
            }
            return mappedString;
        }
        return source.columnName;
    }

    protected void resetInternalState(SpreadSheet[] spreadsheets) {
        this.m_Spreadsheets = spreadsheets;
        this.m_ClassColumns = null;
    }

    protected abstract Enumeration<int[]> getRowSetEnumeration();

    protected static class SourceColumn
    implements Comparable<SourceColumn> {
        public final int spreadsheetIndex;
        public final int columnIndex;
        public final String columnName;

        public SourceColumn(int spreadsheetIndex, int columnIndex, String columnName) {
            this.spreadsheetIndex = spreadsheetIndex;
            this.columnIndex = columnIndex;
            this.columnName = columnName;
        }

        public String toString() {
            return this.columnName + '[' + this.spreadsheetIndex + ", " + this.columnIndex + ']';
        }

        @Override
        public int compareTo(SourceColumn o) {
            if (this.spreadsheetIndex < o.spreadsheetIndex) {
                return -1;
            }
            if (this.spreadsheetIndex > o.spreadsheetIndex) {
                return 1;
            }
            return Integer.compare(this.columnIndex, o.columnIndex);
        }
    }
}

