/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.spreadsheetmethodmerge;

import adams.data.spreadsheet.SpreadSheet;
import adams.flow.transformer.spreadsheetmethodmerge.AbstractMerge;
import java.util.Enumeration;

public class Simple
extends AbstractMerge {
    private static final long serialVersionUID = -6094521682120542873L;

    public String globalInfo() {
        return "Just merges the spreadsheets side by side. Requires the spreadsheets to have the same number of rows.";
    }

    @Override
    protected String check(SpreadSheet[] spreadsheets) {
        String result = super.check(spreadsheets);
        if (result == null) {
            for (int i = 1; i < spreadsheets.length; ++i) {
                if (spreadsheets[0].getRowCount() == spreadsheets[i].getRowCount()) continue;
                return "Spreadsheet #" + (i + 1) + " has " + spreadsheets[i].getRowCount() + " rows instead of " + spreadsheets[0].getRowCount();
            }
        }
        return result;
    }

    @Override
    protected Enumeration<int[]> getRowSetEnumeration() {
        return new SimpleRowSetIterator(this.m_Spreadsheets);
    }

    public static class SimpleRowSetIterator
    implements Enumeration<int[]> {
        private int m_NextRow = 0;
        private int m_RowCount;
        private int m_SpreadsheetCount;

        private SimpleRowSetIterator(SpreadSheet[] spreadsheets) {
            this.m_RowCount = spreadsheets[0].getRowCount();
            this.m_SpreadsheetCount = spreadsheets.length;
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_NextRow < this.m_RowCount;
        }

        @Override
        public int[] nextElement() {
            int[] nextElement = new int[this.m_SpreadsheetCount];
            for (int i = 0; i < nextElement.length; ++i) {
                nextElement[i] = this.m_NextRow;
            }
            ++this.m_NextRow;
            return nextElement;
        }
    }
}

