/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.core.base.BaseInterval;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.spreadsheettable.AbstractCellRenderingCustomizer;
import java.awt.Color;

public class NumericRangeCellRenderingCustomizer
extends AbstractCellRenderingCustomizer {
    private static final long serialVersionUID = 9158498328244673972L;
    protected SpreadSheetColumnRange m_Columns;
    protected BaseInterval[] m_Ranges;
    protected Color m_Highlight;

    public String globalInfo() {
        return "Uses the defined ranges to determine whether a numeric cells gets highlighted with the specified color.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "columns", (Object)new SpreadSheetColumnRange("first-last"));
        this.m_OptionManager.add("range", "ranges", (Object)new BaseInterval[]{new BaseInterval("(-Infinity;+Infinity)")});
        this.m_OptionManager.add("highlight", "highlight", (Object)Color.RED);
    }

    public void setColumns(SpreadSheetColumnRange value) {
        this.m_Columns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The columns to apply the renderer to; " + this.m_Columns.getExample();
    }

    public void setRanges(BaseInterval[] value) {
        this.m_Ranges = value;
        this.reset();
    }

    public BaseInterval[] getRanges() {
        return this.m_Ranges;
    }

    public String rangesTipText() {
        return "The intervals to use for matching numeric values.";
    }

    public void setHighlight(Color value) {
        this.m_Highlight = value;
        this.reset();
    }

    public Color getHighlight() {
        return this.m_Highlight;
    }

    public String highlightTipText() {
        return "The color to use as background for the matching cells.";
    }

    public Color getBackgroundColor(SpreadSheetTable table, boolean isSelected, boolean hasFocus, int row, int column, Cell cell, Color defColor) {
        if (column == 0 && table.getShowRowColumn()) {
            return super.getBackgroundColor(table, isSelected, hasFocus, row, column, cell, defColor);
        }
        if (cell == null || !cell.isNumeric()) {
            return defColor;
        }
        if (table.getShowRowColumn()) {
            --column;
        }
        this.m_Columns.setData(table.toSpreadSheet());
        if (!this.m_Columns.isInRange(column)) {
            return defColor;
        }
        double value = cell.toDouble();
        for (BaseInterval range : this.m_Ranges) {
            if (!range.isInside(value)) continue;
            if (isSelected) {
                return this.m_Highlight.darker();
            }
            return this.m_Highlight;
        }
        return defColor;
    }
}

