/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetprocessor.targets;

import adams.core.MessageCollection;
import adams.core.logging.LoggingLevel;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTextField;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanel;
import adams.gui.event.SpreadSheetProcessorEvent;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.spreadsheetprocessor.AbstractWidget;
import adams.gui.tools.spreadsheetprocessor.targets.AbstractTarget;
import adams.gui.tools.spreadsheetviewer.chart.AbstractChartGenerator;
import adams.gui.tools.spreadsheetviewer.chart.ScatterPlot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public class ChartTarget
extends AbstractTarget {
    private static final long serialVersionUID = 6535516712611654393L;
    public static final String KEY_CHART = "chart";
    public static final String KEY_TITLE = "title";
    protected BasePanel m_Widget;
    protected GenericObjectEditorPanel m_PanelChart;
    protected BaseTextField m_TextTitle;
    protected BaseButton m_ButtonGenerate;

    @Override
    public String getName() {
        return "Chart";
    }

    @Override
    public Component getWidget() {
        if (this.m_Widget == null) {
            this.m_Widget = new BasePanel((LayoutManager)new BorderLayout());
            ParameterPanel panelParams = new ParameterPanel();
            this.m_Widget.add((Component)panelParams, (Object)"Center");
            this.m_PanelChart = new GenericObjectEditorPanel(AbstractChartGenerator.class, (Object)new ScatterPlot());
            panelParams.addParameter("Chart", (Component)this.m_PanelChart);
            this.m_TextTitle = new BaseTextField();
            panelParams.addParameter("Title", (Component)this.m_TextTitle);
            this.m_ButtonGenerate = new BaseButton((Icon)GUIHelper.getIcon((String)"run.gif"));
            this.m_ButtonGenerate.addActionListener(e -> this.generate());
            JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
            panel.add((Component)this.m_ButtonGenerate);
            panelParams.addParameter("Generate", (Component)panel);
        }
        return this.m_Widget;
    }

    @Override
    public void update() {
        this.m_ButtonGenerate.setEnabled(this.m_Owner.getProcessorData() != null);
    }

    protected void generate() {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ChartTarget.this.m_ButtonGenerate.setEnabled(false);
                ChartTarget.this.m_Owner.processorStateChanged(new SpreadSheetProcessorEvent(ChartTarget.this.m_Owner, SpreadSheetProcessorEvent.EventType.OUTPUT_DATA, "Generated chart: " + OptionUtils.getCommandLine((Object)ChartTarget.this.m_PanelChart.getCurrent())));
                return null;
            }

            @Override
            protected void done() {
                super.done();
                ChartTarget.this.m_ButtonGenerate.setEnabled(true);
            }
        };
        worker.execute();
    }

    public void setCurrentChart(AbstractChartGenerator value) {
        this.m_PanelChart.setCurrent((Object)value);
    }

    public AbstractChartGenerator getCurrentChart() {
        return (AbstractChartGenerator)((Object)this.m_PanelChart.getCurrent());
    }

    public void setCurrentTitle(String value) {
        this.m_TextTitle.setText(value);
    }

    public String getCurrentTitle() {
        return this.m_TextTitle.getText();
    }

    @Override
    public void assign(AbstractWidget other) {
        if (other instanceof ChartTarget) {
            ChartTarget widget = (ChartTarget)other;
            widget.getWidget();
            this.setCurrentChart(widget.getCurrentChart());
            this.setCurrentTitle(widget.getCurrentTitle());
        }
    }

    @Override
    public Object serialize() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(KEY_CHART, OptionUtils.getCommandLine((Object)((Object)this.getCurrentChart())));
        result.put(KEY_TITLE, this.getCurrentTitle());
        return result;
    }

    @Override
    public void deserialize(Object data, MessageCollection errors) {
        if (data instanceof Map) {
            Map map = (Map)data;
            if (map.containsKey(KEY_CHART)) {
                try {
                    this.setCurrentChart((AbstractChartGenerator)((Object)OptionUtils.forAnyCommandLine(AbstractChartGenerator.class, (String)((String)map.get(KEY_CHART)))));
                }
                catch (Exception e) {
                    errors.add(this.getClass().getName() + ": Failed to instantiate chart from: " + map.get(KEY_CHART));
                }
            }
            if (map.containsKey(KEY_TITLE)) {
                this.m_TextTitle.setText((String)map.get(KEY_TITLE));
            }
            this.update();
        } else {
            errors.add(this.getClass().getName() + ": Deserialization data is not a map!");
        }
    }

    @Override
    protected void doProcess(SpreadSheet data, MessageCollection errors) {
        final AbstractChartGenerator generator = (AbstractChartGenerator)((Object)this.m_PanelChart.getCurrent());
        String title = this.m_TextTitle.getText().isEmpty() ? "Chart" : this.m_TextTitle.getText();
        final Flow flow = generator.generate(title, data);
        flow.setParentComponent((Component)((Object)this.m_Owner));
        SwingWorker worker = new SwingWorker(){
            String msg = null;

            protected Object doInBackground() throws Exception {
                this.msg = flow.setUp();
                if (this.msg != null) {
                    this.msg = "Failed to setup flow for generating chart:\n" + this.msg;
                }
                if (this.msg == null) {
                    this.msg = flow.execute();
                    if (this.msg != null) {
                        this.msg = "Failed to execute flow for generating chart:\n" + this.msg;
                    }
                }
                if (this.msg == null) {
                    flow.wrapUp();
                    if (flow.hasStopMessage()) {
                        this.msg = "Flow execution for generating chart was stopped:\n" + flow.getStopMessage();
                    }
                }
                return this.msg;
            }

            @Override
            protected void done() {
                super.done();
                if (this.msg != null) {
                    GUIHelper.showErrorMessage((Component)((Object)ChartTarget.this.m_Owner), (String)this.msg);
                    ConsolePanel.getSingleton().append(LoggingLevel.SEVERE, this.msg + "\n");
                    ConsolePanel.getSingleton().append(LoggingLevel.SEVERE, flow.toCommandLine() + "\n");
                    flow.destroy();
                } else {
                    ChartTarget.this.m_Owner.addGeneratedFlow((Actor)flow);
                    ChartTarget.this.notifyOwner(SpreadSheetProcessorEvent.EventType.DATA_IS_OUTPUT, "Generated chart: " + generator.toCommandLine());
                }
            }
        };
        worker.execute();
    }
}

