/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer.chart;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.sink.SequencePlotter;
import adams.flow.sink.sequenceplotter.MouseClickAction;
import adams.flow.sink.sequenceplotter.ViewDataClickAction;
import adams.flow.transformer.SpreadSheetPlotGenerator;
import adams.gui.tools.spreadsheetviewer.chart.AbstractXYChartGenerator;
import adams.gui.visualization.sequence.BarPaintlet;
import adams.gui.visualization.sequence.XYSequencePaintlet;

public class BarPlot
extends AbstractXYChartGenerator {
    private static final long serialVersionUID = -2088311829009151566L;
    protected int m_BarWidth;
    protected int m_Offset;

    public String globalInfo() {
        return "Generates a bar plot by plotting the X column against the Y column.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("bar-width", "barWidth", (Object)10, (Number)1, null);
        this.m_OptionManager.add("offset", "offset", (Object)3, (Number)0, null);
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"barWidth", (Object)this.m_BarWidth, (String)", bar: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"offset", (Object)this.m_Offset, (String)", offset: ");
        return result;
    }

    public void setBarWidth(int value) {
        this.m_BarWidth = value;
        this.reset();
    }

    public int getBarWidth() {
        return this.m_BarWidth;
    }

    public String barWidthTipText() {
        return "The width of the bar in pixel.";
    }

    public void setOffset(int value) {
        this.m_Offset = value;
        this.reset();
    }

    public int getOffset() {
        return this.m_Offset;
    }

    public String offsetTipText() {
        return "The offset in pixel for multiple plots.";
    }

    @Override
    protected void addChartGeneration(Flow flow, String name, SpreadSheet sheet) {
        super.addChartGeneration(flow, name, sheet);
        SpreadSheetPlotGenerator pg = this.configureGenerator(sheet);
        flow.add((Actor)pg);
        SequencePlotter plotter = new SequencePlotter();
        if (name != null) {
            plotter.setName(name);
        } else {
            plotter.setName("Bar plot");
        }
        plotter.setTitle(plotter.getName());
        this.configureSequencePlotter(sheet, plotter);
        BarPaintlet paintlet = new BarPaintlet();
        paintlet.setOffset(3);
        paintlet.setPaintAll(true);
        paintlet.setWidth(this.m_BarWidth);
        plotter.setPaintlet((XYSequencePaintlet)paintlet);
        ViewDataClickAction action = new ViewDataClickAction();
        action.setHitDetector(paintlet.getHitDetector());
        plotter.setMouseClickAction((MouseClickAction)action);
        flow.add((Actor)plotter);
    }
}

