/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer.tab;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.colstatistic.AbstractColumnStatistic;
import adams.data.spreadsheet.colstatistic.Sum;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.core.TableRowRange;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItemHelper;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.spreadsheetviewer.SpreadSheetPanel;
import adams.gui.tools.spreadsheetviewer.tab.AbstractViewerTab;
import adams.gui.tools.spreadsheetviewer.tab.SelectionAwareViewerTab;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.table.TableModel;

public class ColumnStatistic
extends AbstractViewerTab
implements SelectionAwareViewerTab {
    private static final long serialVersionUID = -4215008790991120558L;
    protected GenericObjectEditorPanel m_PanelGOE;
    protected SortableAndSearchableTable m_Table;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelGOE = new GenericObjectEditorPanel(AbstractColumnStatistic.class, (Object)new Sum(), true);
        this.add((Component)this.m_PanelGOE, "North");
        this.m_Table = new SortableAndSearchableTable();
        this.m_Table.setAutoResizeMode(4);
        this.add((Component)new BaseScrollPane((Component)this.m_Table), "Center");
    }

    @Override
    public String getTitle() {
        return "Column stats";
    }

    @Override
    public void sheetSelectionChanged(SpreadSheetPanel panel, SpreadSheetTablePopupMenuItemHelper.TableState state) {
        if (panel == null) {
            return;
        }
        SpreadSheetTableModel model = new SpreadSheetTableModel();
        if (state.selCol != -1 && state.selRows.length > 0) {
            SpreadSheet data = state.table.toSpreadSheet(TableRowRange.SELECTED, true);
            AbstractColumnStatistic statistic = (AbstractColumnStatistic)((Object)this.m_PanelGOE.getCurrent());
            SpreadSheet calculated = statistic.generate(data, state.actCol);
            if (calculated != null) {
                model = new SpreadSheetTableModel(calculated);
            }
        }
        model.setUseSimpleHeader(true);
        model.setShowRowColumn(false);
        this.m_Table.setModel((TableModel)model);
    }
}

