/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer.tab;

import adams.core.Properties;
import adams.env.Environment;
import adams.gui.core.BaseTabbedPaneWithTabHiding;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItemHelper;
import adams.gui.tools.SpreadSheetViewerPanel;
import adams.gui.tools.spreadsheetviewer.SpreadSheetPanel;
import adams.gui.tools.spreadsheetviewer.tab.AbstractViewerTab;
import adams.gui.tools.spreadsheetviewer.tab.SelectionAwareViewerTab;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class ViewerTabManager
extends BaseTabbedPaneWithTabHiding {
    private static final long serialVersionUID = 3685631497946681192L;
    public static final String SESSION_FILE = "SpreadSheetViewerTabManagerSession.props";
    public static final String MENUITEM_TABS = "Show tabs";
    public static final String SUFFIX_VISIBLE = ".Visible";
    protected SpreadSheetViewerPanel m_Owner;
    protected static Properties m_Properties;
    protected List<AbstractViewerTab> m_TabList;

    public ViewerTabManager(SpreadSheetViewerPanel owner) {
        this.m_Owner = owner;
    }

    protected void initialize() {
        super.initialize();
        this.setPreferredSize(new Dimension(300, 0));
        this.setCloseTabsWithMiddleMouseButton(false);
        String[] tabs = AbstractViewerTab.getTabs();
        this.m_TabList = new ArrayList<AbstractViewerTab>();
        Properties props = ViewerTabManager.getProperties();
        boolean update = false;
        for (String tabName : tabs) {
            AbstractViewerTab tab = AbstractViewerTab.forName(tabName);
            if (tab == null) continue;
            tab.setOwner(this);
            this.m_TabList.add(tab);
            String key = this.createPropertyKey(tab.getClass());
            if (props.hasKey(key)) continue;
            props.setBoolean(key, Boolean.valueOf(true));
            update = true;
        }
        Collections.sort(this.m_TabList);
        if (update) {
            this.updateProperties();
        }
    }

    protected void initGUI() {
        super.initGUI();
        for (int i = 0; i < this.m_TabList.size(); ++i) {
            AbstractViewerTab tab = this.m_TabList.get(i);
            this.addTab(tab.getTitle(), (Component)((Object)tab));
            if (this.isVisible(tab.getClass())) continue;
            this.hideTab((Component)((Object)tab));
        }
    }

    public SpreadSheetViewerPanel getOwner() {
        return this.m_Owner;
    }

    public void notifyTabs(SpreadSheetPanel panel) {
        this.notifyTabs(panel, panel == null ? new SpreadSheetTablePopupMenuItemHelper.TableState() : SpreadSheetTablePopupMenuItemHelper.getState((SpreadSheetTable)panel.getTable()));
    }

    public void notifyTabs(SpreadSheetPanel panel, SpreadSheetTablePopupMenuItemHelper.TableState state) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!(this.getComponentAt(i) instanceof SelectionAwareViewerTab)) continue;
            ((SelectionAwareViewerTab)((Object)this.getComponentAt(i))).sheetSelectionChanged(panel, state);
        }
    }

    public void refresh(SpreadSheetPanel panel) {
        if (panel == null) {
            return;
        }
        this.notifyTabs(panel, SpreadSheetTablePopupMenuItemHelper.getState((SpreadSheetTable)panel.getTable()));
    }

    public void addTabsSubmenu(JMenu menu) {
        JMenu submenu = new JMenu(MENUITEM_TABS);
        submenu.addChangeListener(e -> this.updateMenu(submenu));
        menu.add(submenu);
        JMenuItem menuitem = new JMenuItem("Enable all");
        menuitem.addActionListener(e -> this.setAllVisible(true));
        submenu.add(menuitem);
        menuitem = new JMenuItem("Disable all");
        menuitem.addActionListener(e -> this.setAllVisible(false));
        submenu.add(menuitem);
        boolean first = true;
        for (AbstractViewerTab tab : this.m_TabList) {
            if (first) {
                first = false;
                submenu.addSeparator();
            }
            menuitem = new JCheckBoxMenuItem(tab.getTitle());
            menuitem.setSelected(this.isVisible(tab.getClass()));
            menuitem.addActionListener(e -> {
                this.setVisible(tab.getClass(), !this.isVisible(tab.getClass()));
                if (this.isVisible(tab.getClass())) {
                    this.displayTab((Component)((Object)tab));
                } else {
                    this.hideTab((Component)((Object)tab));
                }
            });
            submenu.add(menuitem);
        }
    }

    protected void updateMenu(JMenu menu) {
        block0: for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            if (!(menu.getMenuComponent(i) instanceof JCheckBoxMenuItem)) continue;
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)menu.getMenuComponent(i);
            for (int n = 0; n < this.m_TabList.size(); ++n) {
                if (!item.getText().equals(this.m_TabList.get(n).getTitle())) continue;
                item.setSelected(this.isVisible(this.m_TabList.get(n).getClass()));
                continue block0;
            }
        }
    }

    protected String createPropertyKey(Class cls) {
        return cls.getName() + SUFFIX_VISIBLE;
    }

    public synchronized boolean isVisible(Class cls) {
        return ViewerTabManager.getProperties().getBoolean(this.createPropertyKey(cls), Boolean.valueOf(true));
    }

    public synchronized void setVisible(Class cls, boolean value) {
        ViewerTabManager.getProperties().setBoolean(this.createPropertyKey(cls), Boolean.valueOf(value));
        this.updateProperties();
    }

    public synchronized void setAllVisible(boolean value) {
        for (AbstractViewerTab tab : this.m_TabList) {
            ViewerTabManager.getProperties().setBoolean(this.createPropertyKey(tab.getClass()), Boolean.valueOf(value));
            if (value) {
                this.displayTab((Component)((Object)tab));
                continue;
            }
            this.hideTab((Component)((Object)tab));
        }
        this.updateProperties();
    }

    protected synchronized boolean updateProperties() {
        String filename = Environment.getInstance().createPropertiesFilename(SESSION_FILE);
        return ViewerTabManager.getProperties().save(filename);
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                m_Properties = Properties.read((String)SESSION_FILE);
            }
            catch (Exception e) {
                m_Properties = new Properties();
            }
        }
        return m_Properties;
    }
}

