/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objectrenderer;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetView;
import adams.gui.core.BaseButton;
import adams.gui.dialog.SpreadSheetPanel;
import adams.gui.visualization.debug.objectrenderer.AbstractObjectRenderer;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JPanel;
import nz.ac.waikato.cms.locator.ClassLocator;

public class SpreadSheetRenderer
extends AbstractObjectRenderer {
    private static final long serialVersionUID = -3528006886476495175L;
    public static final int MAX_ROWS = 100;
    protected SpreadSheetPanel m_LastPanel;

    public boolean handles(Class cls) {
        return ClassLocator.hasInterface(SpreadSheet.class, (Class)cls);
    }

    public boolean canRenderCached(Object obj, JPanel panel) {
        return this.m_LastPanel != null;
    }

    protected String doRenderCached(Object obj, JPanel panel) {
        this.m_LastPanel.setSpreadSheet((SpreadSheet)obj);
        this.m_LastPanel.setShowSearch(true);
        panel.add((Component)this.m_LastPanel, "Center");
        return null;
    }

    protected String doRender(Object obj, JPanel panel) {
        SpreadSheet sheet = (SpreadSheet)obj;
        if (sheet.getRowCount() >= 100) {
            SpreadSheetPanel sheetPanel = new SpreadSheetPanel();
            SpreadSheetView view = new SpreadSheetView(sheet, 0, 100);
            sheetPanel.setSpreadSheet((SpreadSheet)view);
            sheetPanel.setShowSearch(true);
            panel.add((Component)sheetPanel, "Center");
            JPanel panelButton = new JPanel(new FlowLayout(0));
            panel.add((Component)panelButton, "South");
            BaseButton buttonAll = new BaseButton("Show all " + sheet.getRowCount() + " rows");
            buttonAll.addActionListener(e -> {
                sheetPanel.setSpreadSheet(sheet);
                panelButton.setVisible(false);
                this.m_LastPanel = sheetPanel;
            });
            panelButton.add((Component)buttonAll);
        } else {
            SpreadSheetPanel sheetPanel = new SpreadSheetPanel();
            sheetPanel.setSpreadSheet(sheet);
            sheetPanel.setShowSearch(true);
            panel.add((Component)sheetPanel, "Center");
            this.m_LastPanel = sheetPanel;
        }
        return null;
    }
}

