/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.jfreechart.dataset;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.data.statistics.StatUtils;
import adams.gui.visualization.jfreechart.dataset.AbstractDatasetGenerator;
import adams.gui.visualization.jfreechart.dataset.ChartUtils;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.DefaultXYDataset;

public class DefaultXY
extends AbstractDatasetGenerator<DefaultXYDataset> {
    private static final long serialVersionUID = -690091259560326881L;
    protected SpreadSheetColumnIndex m_X;
    protected SpreadSheetColumnRange m_Y;
    protected boolean m_AddDiagonalSeries;

    public String globalInfo() {
        return "For each of the Y columns, a separate series is generated.\nThe column name is used as name for each series.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "X", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("y", "Y", (Object)new SpreadSheetColumnRange("2"));
        this.m_OptionManager.add("add-diagonal-series", "addDiagonalSeries", (Object)false);
    }

    public void setX(SpreadSheetColumnIndex value) {
        this.m_X = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The index of the column in the spreadsheet to use for the X axis; if left empty, the row index is used instead.";
    }

    public void setY(SpreadSheetColumnRange value) {
        this.m_Y = value;
        this.reset();
    }

    public SpreadSheetColumnRange getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The columns in the spreadsheet to use for the Y axis/axes.";
    }

    public void setAddDiagonalSeries(boolean value) {
        this.m_AddDiagonalSeries = value;
        this.reset();
    }

    public boolean getAddDiagonalSeries() {
        return this.m_AddDiagonalSeries;
    }

    public String addDiagonalSeriesTipText() {
        return "If enabled, a second series with data points for a diagonal get added.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"X", (Object)((Object)this.m_X), (String)"X: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"Y", (Object)((Object)this.m_Y), (String)", Y: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"addDiagonalSeries", (boolean)this.m_AddDiagonalSeries, (String)"diagonal", (String)", ");
        return result;
    }

    @Override
    public Class<? extends Dataset> generates() {
        return DefaultXYDataset.class;
    }

    @Override
    protected String check(SpreadSheet data) {
        String result = super.check(data);
        if (result == null) {
            if (!this.m_X.isEmpty()) {
                this.m_X.setData(data);
                if (this.m_X.getIntIndex() == -1) {
                    result = "X column not valid? Provided: " + (Object)((Object)this.m_X);
                }
            }
            this.m_Y.setData(data);
            if (this.m_Y.getIntIndices().length == 0) {
                result = "No Y column(s) available? Provided: " + (Object)((Object)this.m_Y);
            }
        }
        return result;
    }

    @Override
    protected DefaultXYDataset doGenerate(SpreadSheet data) {
        return this.addSeries(new DefaultXYDataset(), data);
    }

    @Override
    protected DefaultXYDataset doAddSeries(Dataset dataset, SpreadSheet data) {
        int i;
        double[] plotX;
        DefaultXYDataset result = (DefaultXYDataset)dataset;
        if (this.m_X.isEmpty()) {
            plotX = new double[data.getRowCount()];
            for (i = 0; i < plotX.length; ++i) {
                plotX[i] = i;
            }
        } else {
            this.m_X.setData(data);
            int x = this.m_X.getIntIndex();
            plotX = SpreadSheetUtils.getNumericColumn((SpreadSheet)data, (int)x);
        }
        this.m_Y.setData(data);
        int[] y = this.m_Y.getIntIndices();
        double min = StatUtils.min((double[])plotX);
        double max = StatUtils.max((double[])plotX);
        for (i = 0; i < y.length; ++i) {
            double[] plotY = SpreadSheetUtils.getNumericColumn((SpreadSheet)data, (int)y[i]);
            min = Math.min(min, StatUtils.min((double[])plotY));
            max = Math.max(max, StatUtils.max((double[])plotY));
            result.addSeries((Comparable)((Object)data.getColumnName(y[i])), (double[][])new double[][]{plotX, plotY});
        }
        if (this.m_AddDiagonalSeries) {
            ChartUtils.addDiagonal(result, min, max);
        }
        return result;
    }
}

