/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.jfreechart.dataset;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.gui.visualization.jfreechart.dataset.AbstractDatasetGenerator;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.DefaultXYZDataset;

public class DefaultXYZ
extends AbstractDatasetGenerator<DefaultXYZDataset> {
    private static final long serialVersionUID = -690091259560326881L;
    protected SpreadSheetColumnIndex m_X;
    protected SpreadSheetColumnIndex m_Y;
    protected SpreadSheetColumnIndex m_Z;

    public String globalInfo() {
        return "Generates an XYZ dataset from the specified columns.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "X", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("y", "Y", (Object)new SpreadSheetColumnIndex("2"));
        this.m_OptionManager.add("z", "Z", (Object)new SpreadSheetColumnIndex("3"));
    }

    public void setX(SpreadSheetColumnIndex value) {
        this.m_X = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The index of the column in the spreadsheet to use for the X axis.";
    }

    public void setY(SpreadSheetColumnIndex value) {
        this.m_Y = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The column in the spreadsheet to use for the Y axis.";
    }

    public void setZ(SpreadSheetColumnIndex value) {
        this.m_Z = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getZ() {
        return this.m_Z;
    }

    public String ZTipText() {
        return "The column in the spreadsheet to use for the Z axis.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"X", (Object)((Object)this.m_X), (String)"X: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"Y", (Object)((Object)this.m_Y), (String)", Y: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"Z", (Object)((Object)this.m_Z), (String)", Z: ");
        return result;
    }

    @Override
    public Class<? extends Dataset> generates() {
        return DefaultXYZDataset.class;
    }

    @Override
    protected String check(SpreadSheet data) {
        String result = super.check(data);
        if (result == null) {
            this.m_X.setData(data);
            this.m_Y.setData(data);
            this.m_Z.setData(data);
            if (this.m_X.getIntIndex() == -1) {
                result = "X column not valid? Provided: " + (Object)((Object)this.m_X);
            } else if (this.m_Y.getIntIndex() == -1) {
                result = "Y column not valid? Provided: " + (Object)((Object)this.m_Y);
            } else if (this.m_Z.getIntIndex() == -1) {
                result = "Z column not valid? Provided: " + (Object)((Object)this.m_Z);
            }
        }
        return result;
    }

    @Override
    protected DefaultXYZDataset doGenerate(SpreadSheet data) {
        return this.addSeries(new DefaultXYZDataset(), data);
    }

    @Override
    protected DefaultXYZDataset doAddSeries(Dataset dataset, SpreadSheet data) {
        DefaultXYZDataset result = (DefaultXYZDataset)dataset;
        this.m_X.setData(data);
        int x = this.m_X.getIntIndex();
        this.m_Y.setData(data);
        int y = this.m_Y.getIntIndex();
        this.m_Z.setData(data);
        int z = this.m_Z.getIntIndex();
        double[] plotX = SpreadSheetUtils.getNumericColumn((SpreadSheet)data, (int)x);
        double[] plotY = SpreadSheetUtils.getNumericColumn((SpreadSheet)data, (int)y);
        double[] plotZ = SpreadSheetUtils.getNumericColumn((SpreadSheet)data, (int)z);
        result.addSeries((Comparable)((Object)(data.getColumnName(x) + "-" + data.getColumnName(y) + "-" + data.getColumnName(y))), (double[][])new double[][]{plotX, plotY, plotZ});
        return result;
    }
}

