/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractMatrixToSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;

public class DoubleMatrixToSpreadSheet
extends AbstractMatrixToSpreadSheet {
    private static final long serialVersionUID = -2047404866165517428L;

    public String globalInfo() {
        return "Converts a double matrix into a SpreadSheet object.";
    }

    public Class accepts() {
        return Double[][].class;
    }

    protected Object doConvert() throws Exception {
        int i;
        SpreadSheet result = this.newInstance();
        Double[][] matrix = (Double[][])this.getInput();
        HeaderRow row = result.getHeaderRow();
        for (i = 0; i < matrix[0].length; ++i) {
            row.addCell("" + (i + 1)).setContent("col-" + (i + 1));
        }
        for (int n = 0; n < matrix.length; ++n) {
            row = result.addRow("" + (n + 1));
            for (i = 0; i < matrix[0].length; ++i) {
                row.addCell("" + (i + 1)).setContent(matrix[n][i]);
            }
        }
        return result;
    }
}

