/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractSpreadSheetConversion;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;

public class TransposeSpreadSheet
extends AbstractSpreadSheetConversion {
    private static final long serialVersionUID = 4733940137387662202L;
    protected boolean m_UseHeaderAsFirstColumn;
    protected boolean m_UseFirstColumnAsHeader;
    protected String m_ColumnPrefix;

    public String globalInfo() {
        return "Transposes a spreadsheet, i.e., swaps columns with rows.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("use-header-as-first-column", "useHeaderAsFirstColumn", (Object)false);
        this.m_OptionManager.add("use-first-column-as-header", "useFirstColumnAsHeader", (Object)false);
        this.m_OptionManager.add("column-prefix", "columnPrefix", (Object)"col-");
    }

    public void setUseHeaderAsFirstColumn(boolean value) {
        this.m_UseHeaderAsFirstColumn = value;
        this.reset();
    }

    public boolean getUseHeaderAsFirstColumn() {
        return this.m_UseHeaderAsFirstColumn;
    }

    public String useHeaderAsFirstColumnTipText() {
        return "Whether to use the current header as first column.";
    }

    public void setUseFirstColumnAsHeader(boolean value) {
        this.m_UseFirstColumnAsHeader = value;
        this.reset();
    }

    public boolean getUseFirstColumnAsHeader() {
        return this.m_UseFirstColumnAsHeader;
    }

    public String useFirstColumnAsHeaderTipText() {
        return "Whether to use the first column as new header.";
    }

    public void setColumnPrefix(String value) {
        this.m_ColumnPrefix = value;
        this.reset();
    }

    public String getColumnPrefix() {
        return this.m_ColumnPrefix;
    }

    public String columnPrefixTipText() {
        return "The column prefix for the new columns if the first column is not used for the header; 1-based column index is appended.";
    }

    protected Cell[][] toMatrix(SpreadSheet sheet) {
        int x;
        Cell[][] result = new Cell[sheet.getRowCount() + 1][sheet.getColumnCount()];
        HeaderRow row = sheet.getHeaderRow();
        for (x = 0; x < sheet.getColumnCount(); ++x) {
            result[0][x] = null;
            if (!row.hasCell(x) || row.getCell(x).isMissing()) continue;
            result[0][x] = row.getCell(x);
        }
        for (int y = 0; y < sheet.getRowCount(); ++y) {
            row = sheet.getRow(y);
            for (x = 0; x < sheet.getColumnCount(); ++x) {
                result[y + 1][x] = null;
                if (!row.hasCell(x) || row.getCell(x).isMissing()) continue;
                result[y + 1][x] = row.getCell(x);
            }
        }
        return result;
    }

    protected Cell[][] transpose(Cell[][] matrix) {
        Cell[][] result = new Cell[matrix[0].length][matrix.length];
        for (int y = 0; y < matrix.length; ++y) {
            for (int x = 0; x < matrix[0].length; ++x) {
                result[x][y] = matrix[y][x];
            }
        }
        return result;
    }

    @Override
    protected SpreadSheet convert(SpreadSheet input) throws Exception {
        SpreadSheet result;
        block19: {
            int x;
            Cell[][] matrix;
            block21: {
                int x2;
                block20: {
                    int x3;
                    block18: {
                        int x4;
                        result = input.newInstance();
                        result.setDataRowClass(input.getDataRowClass());
                        result.setName(input.getName() + "-transposed");
                        for (String comment : input.getComments()) {
                            result.addComment(comment);
                        }
                        matrix = this.transpose(this.toMatrix(input));
                        if (this.m_UseFirstColumnAsHeader || this.m_UseHeaderAsFirstColumn) break block18;
                        HeaderRow rowOut = result.getHeaderRow();
                        for (x4 = 1; x4 < matrix[0].length; ++x4) {
                            rowOut.addCell("" + (x4 - 1)).setContent(this.m_ColumnPrefix + x4);
                        }
                        for (int y = 0; y < matrix.length; ++y) {
                            rowOut = result.addRow();
                            for (x4 = 1; x4 < matrix[0].length; ++x4) {
                                if (matrix[y][x4] == null) {
                                    rowOut.addCell(x4 - 1).setMissing();
                                    continue;
                                }
                                rowOut.addCell(x4 - 1).assign(matrix[y][x4]);
                            }
                        }
                        break block19;
                    }
                    if (!this.m_UseFirstColumnAsHeader || this.m_UseHeaderAsFirstColumn) break block20;
                    HeaderRow rowOut = result.getHeaderRow();
                    for (x3 = 1; x3 < matrix[0].length; ++x3) {
                        rowOut.addCell("" + (x3 - 1)).assign(matrix[0][x3]);
                    }
                    for (int y = 1; y < matrix.length; ++y) {
                        rowOut = result.addRow();
                        for (x3 = 1; x3 < matrix[0].length; ++x3) {
                            if (matrix[y][x3] == null) {
                                rowOut.addCell(x3 - 1).setMissing();
                                continue;
                            }
                            rowOut.addCell(x3 - 1).assign(matrix[y][x3]);
                        }
                    }
                    break block19;
                }
                if (this.m_UseFirstColumnAsHeader || !this.m_UseHeaderAsFirstColumn) break block21;
                HeaderRow rowOut = result.getHeaderRow();
                for (x2 = 0; x2 < matrix[0].length; ++x2) {
                    rowOut.addCell("" + x2).setContent(this.m_ColumnPrefix + (x2 + 1));
                }
                for (int y = 0; y < matrix.length; ++y) {
                    rowOut = result.addRow();
                    for (x2 = 0; x2 < matrix[0].length; ++x2) {
                        if (matrix[y][x2] == null) {
                            rowOut.addCell(x2).setMissing();
                            continue;
                        }
                        rowOut.addCell(x2).assign(matrix[y][x2]);
                    }
                }
                break block19;
            }
            if (!this.m_UseFirstColumnAsHeader || !this.m_UseHeaderAsFirstColumn) break block19;
            HeaderRow rowOut = result.getHeaderRow();
            int y = 0;
            for (x = 0; x < matrix[0].length; ++x) {
                if (matrix[y][x] == null) {
                    rowOut.addCell("" + x).setContent(this.m_ColumnPrefix + (x + 1));
                    continue;
                }
                rowOut.addCell("" + x).assign(matrix[y][x]);
            }
            for (y = 1; y < matrix.length; ++y) {
                rowOut = result.addRow();
                for (x = 0; x < matrix[0].length; ++x) {
                    if (matrix[y][x] == null) {
                        rowOut.addCell(x).setMissing();
                        continue;
                    }
                    rowOut.addCell(x).assign(matrix[y][x]);
                }
            }
        }
        return result;
    }
}

