/*
 * Decompiled with CFR 0.152.
 */
package adams.data.groupextraction;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.groupextraction.AbstractGroupExtractor;
import adams.data.groupextraction.SpreadSheetRowGroupExtractorWithColumn;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheetColumnIndex;

public class SpreadSheetCell
extends AbstractGroupExtractor
implements SpreadSheetRowGroupExtractorWithColumn {
    private static final long serialVersionUID = 6130414784797102811L;
    protected SpreadSheetColumnIndex m_Column;

    public String globalInfo() {
        return "Returns the cell value of the spreadsheet row.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("column", "column", (Object)new SpreadSheetColumnIndex("first"));
    }

    @Override
    public void setColumn(SpreadSheetColumnIndex value) {
        this.m_Column = value;
        this.reset();
    }

    @Override
    public SpreadSheetColumnIndex getColumn() {
        return this.m_Column;
    }

    @Override
    public String columnTipText() {
        return "The column of the cell to get the group from.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"column", (Object)((Object)this.m_Column), (String)"col:");
    }

    public boolean handles(Object obj) {
        return obj instanceof Row;
    }

    protected String doExtractGroup(Object obj) {
        Row row = (Row)obj;
        this.m_Column.setSpreadSheet(row.getOwner());
        if (this.m_Column.getIntIndex() == -1) {
            throw new IllegalStateException("Failed to locate column: " + (Object)((Object)this.m_Column));
        }
        Cell cell = row.getCell(this.m_Column.getIntIndex());
        if (cell != null && !cell.isMissing()) {
            return cell.getContent();
        }
        return null;
    }
}

