/*
 * Decompiled with CFR 0.152.
 */
package adams.data.groupextraction;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseKeyValuePair;
import adams.core.option.OptionHandler;
import adams.data.groupextraction.SpreadSheetCell;
import java.util.HashMap;
import java.util.Map;

public class SpreadSheetCellWithLookUp
extends SpreadSheetCell {
    private static final long serialVersionUID = 6130414784797102811L;
    protected BaseKeyValuePair[] m_LookUps;
    protected MissingLookUpKey m_MissingKey;
    protected String m_MissingValue;
    protected boolean m_SuppressMissingKeyWarnings;
    protected transient Map<String, String> m_Table;

    @Override
    public String globalInfo() {
        return "Returns the cell value of the spreadsheet row.\nIf lookups are supplied, then the cell value is checked against the keys in the lookup table for replacement.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("lookup", "lookUps", (Object)new BaseKeyValuePair[0]);
        this.m_OptionManager.add("missing-key", "missingKey", (Object)MissingLookUpKey.OUTPUT_KEY);
        this.m_OptionManager.add("missing-value", "missingValue", (Object)"???");
        this.m_OptionManager.add("suppress-missing-key-warnings", "suppressMissingKeyWarnings", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_Table = null;
    }

    public void setLookUps(BaseKeyValuePair[] value) {
        this.m_LookUps = value;
        this.reset();
    }

    public BaseKeyValuePair[] getLookUps() {
        return this.m_LookUps;
    }

    public String lookUpsTipText() {
        return "The key-value pairs to generate the lookup table from.";
    }

    public void setMissingKey(MissingLookUpKey value) {
        this.m_MissingKey = value;
        this.reset();
    }

    public MissingLookUpKey getMissingKey() {
        return this.m_MissingKey;
    }

    public String missingKeyTipText() {
        return "The behavior in case a lookup key is missing (ie not found in the lookup table).";
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
        this.reset();
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The value to forward if the missing key behavior is " + (Object)((Object)MissingLookUpKey.OUTPUT_MISSING_VALUE) + ".";
    }

    public void setSuppressMissingKeyWarnings(boolean value) {
        this.m_SuppressMissingKeyWarnings = value;
        this.reset();
    }

    public boolean getSuppressMissingKeyWarnings() {
        return this.m_SuppressMissingKeyWarnings;
    }

    public String suppressMissingKeyWarningsTipText() {
        return "If enabled, warnings about missing keys are suppressed.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"lookUps", (Object)this.m_LookUps, (String)", lookups: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"missingKey", (Object)((Object)this.m_MissingKey), (String)", missing: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"missingValue", (Object)this.m_MissingValue, (String)", value: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"suppressMissingKeyWarnings", (boolean)this.m_SuppressMissingKeyWarnings, (String)", no missing key warnings");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    @Override
    protected String doExtractGroup(Object obj) {
        String result = super.doExtractGroup(obj);
        if (result != null && this.m_LookUps.length > 0) {
            String group = result;
            if (this.m_Table == null) {
                this.m_Table = new HashMap<String, String>();
                for (BaseKeyValuePair lookup : this.m_LookUps) {
                    this.m_Table.put(lookup.getPairKey(), lookup.getPairValue());
                }
            }
            if (this.m_Table.containsKey(result)) {
                result = this.m_Table.get(group);
            } else {
                switch (this.m_MissingKey) {
                    case OUTPUT_KEY: {
                        result = group;
                        if (this.m_SuppressMissingKeyWarnings) break;
                        this.getLogger().warning("Key '" + group + "' not available from lookup table!");
                        break;
                    }
                    case OUTPUT_MISSING_VALUE: {
                        result = this.m_MissingValue;
                        if (this.m_SuppressMissingKeyWarnings) break;
                        this.getLogger().warning("Key '" + group + "' not available from lookup table, using missing value: " + this.m_MissingValue);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled missing key behavior: " + (Object)((Object)this.m_MissingKey));
                    }
                }
            }
        }
        return result;
    }

    public static enum MissingLookUpKey {
        OUTPUT_MISSING_VALUE,
        OUTPUT_KEY;

    }
}

