/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Utils;
import adams.core.logging.LoggingHelper;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.input.ChunkedSpreadSheetReader;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.io.output.SqlDumpSpreadSheetWriter;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;

public class SqlDumpSpreadSheetReader
extends AbstractSpreadSheetReader
implements ChunkedSpreadSheetReader {
    private static final long serialVersionUID = -1828187977878321234L;
    protected String m_CustomColumnHeaders;
    protected TimeZone m_TimeZone;
    protected int m_ChunkSize;
    protected boolean m_UseBackslashes;
    protected ChunkReader m_Reader;

    public String globalInfo() {
        return "Reads in SQL dump files.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("custom-column-headers", "customColumnHeaders", (Object)"");
        this.m_OptionManager.add("time-zone", "timeZone", (Object)TimeZone.getDefault(), false);
        this.m_OptionManager.add("use-backslashes", "useBackslashes", (Object)false);
        this.m_OptionManager.add("chunk-size", "chunkSize", (Object)-1, (Number)-1, null);
    }

    public String getFormatDescription() {
        return "SQL dump";
    }

    public String[] getFormatExtensions() {
        return new String[]{"sql"};
    }

    public SpreadSheetWriter getCorrespondingWriter() {
        return new SqlDumpSpreadSheetWriter();
    }

    public void setCustomColumnHeaders(String value) {
        this.m_CustomColumnHeaders = value;
        this.reset();
    }

    public String getCustomColumnHeaders() {
        return this.m_CustomColumnHeaders;
    }

    public String customColumnHeadersTipText() {
        return "The custom headers to use for the columns (comma-separated list).";
    }

    public void setTimeZone(TimeZone value) {
        this.m_TimeZone = value;
        this.reset();
    }

    public TimeZone getTimeZone() {
        return this.m_TimeZone;
    }

    public String timeZoneTipText() {
        return "The time zone to use for interpreting dates/times; default is the system-wide defined one.";
    }

    public void setUseBackslashes(boolean value) {
        this.m_UseBackslashes = value;
        this.reset();
    }

    public boolean getUseBackslashes() {
        return this.m_UseBackslashes;
    }

    public String useBackslashesTipText() {
        return "If enabled, any output file that exists when the writer is executed for the first time won't get replaced with the current header; useful when outputting data in multiple locations in the flow, but one needs to be cautious as to not stored mixed content (eg varying number of columns, etc).";
    }

    public void setChunkSize(int value) {
        if (value < 1) {
            value = -1;
        }
        this.m_ChunkSize = value;
        this.reset();
    }

    public int getChunkSize() {
        return this.m_ChunkSize;
    }

    public String chunkSizeTipText() {
        return "The maximum number of rows per chunk; using -1 will read put all data into a single spreadsheet object.";
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.READER;
    }

    protected SpreadSheet doRead(Reader r) {
        this.m_Reader = new ChunkReader(this);
        return this.m_Reader.read(r, this.m_ChunkSize);
    }

    public boolean hasMoreChunks() {
        return this.m_Reader != null && this.m_Reader.hasNext();
    }

    public SpreadSheet nextChunk() {
        if (this.m_Reader == null || !this.m_Reader.hasNext()) {
            return null;
        }
        return this.m_Reader.next();
    }

    public static class ChunkReader
    implements Serializable {
        private static final long serialVersionUID = 26915431591885853L;
        protected SqlDumpSpreadSheetReader m_Owner;
        protected BufferedReader m_Reader;
        protected SpreadSheet m_Header;
        protected int m_ChunkSize;
        protected boolean m_UseBackslashes;
        protected List<String> m_HeaderCells;

        public ChunkReader(SqlDumpSpreadSheetReader owner) {
            this.m_Owner = owner;
            this.m_UseBackslashes = owner.getUseBackslashes();
        }

        protected String unquote(String s) {
            String result = this.m_UseBackslashes ? Utils.unquote((String)s, (String)"'") : Utils.unDoubleUpQuotes((String)s, (char)'\'', (String[])new String[]{"\\t", "\\n"}, (char[])new char[]{'\t', '\n'});
            return result;
        }

        protected void removeTrailingCR(StringBuilder current) {
            if (current.length() > 0 && current.charAt(current.length() - 1) == '\r') {
                current.delete(current.length() - 1, current.length());
            }
        }

        protected List<String> readCells(Reader reader) throws IOException {
            int in;
            ArrayList<String> result = new ArrayList<String>();
            StringBuilder current = new StringBuilder();
            boolean escaped = false;
            char escapeChr = '\u0000';
            boolean lineFinished = false;
            boolean firstChr = true;
            while (!lineFinished && (in = reader.read()) != -1) {
                firstChr = false;
                char chr = (char)in;
                if (chr == ',') {
                    if (escaped) {
                        current.append(chr);
                        continue;
                    }
                    if (result.size() == 0 && current.toString().toLowerCase().startsWith("insert")) {
                        current.delete(0, current.indexOf("(") + 1);
                    }
                    this.removeTrailingCR(current);
                    result.add(this.unquote(current.toString()));
                    if (current.length() > 0) {
                        current.delete(0, current.length());
                    }
                    escapeChr = '\u0000';
                    continue;
                }
                if (chr == '\'' || chr == '\"') {
                    if (chr == escapeChr) {
                        escaped = !escaped;
                    } else if (escapeChr == '\u0000') {
                        escaped = true;
                        escapeChr = chr;
                    }
                    current.append(chr);
                    continue;
                }
                if (chr == '\n') {
                    if (escaped) {
                        this.removeTrailingCR(current);
                        current.append(chr);
                        continue;
                    }
                    lineFinished = true;
                    continue;
                }
                current.append(chr);
            }
            if (!firstChr) {
                this.removeTrailingCR(current);
                if (current.lastIndexOf(")") > -1) {
                    current.delete(current.lastIndexOf(")"), current.length());
                }
                result.add(this.unquote(current.toString()));
            } else {
                result = null;
            }
            return result;
        }

        public SpreadSheet next() {
            HeaderRow row;
            SpreadSheet result;
            if (this.m_Header == null) {
                result = this.m_Owner.getSpreadSheetType().newInstance();
                result.setTimeZone(this.m_Owner.getTimeZone());
                result.setDataRowClass(this.m_Owner.getDataRowType().getClass());
                this.m_HeaderCells = new ArrayList<String>(Arrays.asList(this.m_Owner.getCustomColumnHeaders().split(",")));
                row = result.getHeaderRow();
                for (String cell : this.m_HeaderCells) {
                    row.addCell("" + result.getColumnCount()).setContentAsString(cell);
                }
            } else {
                result = this.m_Header.getHeader();
            }
            try {
                boolean comments;
                boolean bl = comments = this.m_Header == null;
                while (!this.m_Owner.isStopped()) {
                    List<String> cells = this.readCells(this.m_Reader);
                    if (cells == null) {
                        this.m_Reader.close();
                        this.m_Reader = null;
                    } else {
                        if (comments && (cells.get(0).trim().length() == 0 || cells.get(0).startsWith("--") || cells.get(0).toLowerCase().startsWith("create"))) {
                            if (cells.get(0).startsWith("--")) {
                                result.addComment(Utils.flatten(cells, (String)",").substring(2).trim());
                                continue;
                            }
                            result.addComment(Utils.flatten(cells, (String)",").trim());
                            continue;
                        }
                        comments = false;
                        if (cells.size() == 1 && cells.get(0).trim().length() == 0) continue;
                        row = result.addRow();
                        for (int i = 0; i < this.m_HeaderCells.size() && i < cells.size(); ++i) {
                            if (cells.get(i).equals("NULL")) continue;
                            row.addCell("" + i).setContent(cells.get(i));
                        }
                        if (this.m_ChunkSize <= 0 || result.getRowCount() != this.m_ChunkSize) continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                result = null;
                this.m_Owner.getLogger().log(Level.SEVERE, "Failed to read data!", (Throwable)e);
                this.m_Owner.setLastError("Failed to read data!\n" + LoggingHelper.throwableToString((Throwable)e));
            }
            return result;
        }

        public boolean hasNext() {
            return this.m_Reader != null;
        }

        public SpreadSheet read(Reader r, int chunkSize) {
            this.m_Reader = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
            this.m_Header = null;
            this.m_HeaderCells = null;
            this.m_ChunkSize = chunkSize;
            return this.next();
        }
    }
}

