/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.core.CloneHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import java.io.Serializable;

public class MetaData
implements Serializable,
SpreadSheetSupporter,
CloneHandler<MetaData> {
    private static final long serialVersionUID = -7702963792155360094L;
    protected SpreadSheet m_Data = new DefaultSpreadSheet();

    public MetaData() {
        this.m_Data.getHeaderRow().addCell("K").setContentAsString("Key");
        this.m_Data.getHeaderRow().addCell("V").setContentAsString("Value");
    }

    public MetaData(MetaData source) {
        this();
        for (Row row : source.toSpreadSheet().rows()) {
            this.m_Data.addRow().assign(row);
        }
    }

    public boolean has(String key) {
        boolean result = false;
        for (int i = 0; i < this.m_Data.getRowCount(); ++i) {
            DataRow row = this.m_Data.getRow(i);
            if (!row.hasCell(0) || !row.getCell(0).getContent().equals(key)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void add(String key, Object value) {
        DataRow row = this.m_Data.addRow();
        row.addCell("K").setContentAsString(key);
        row.addCell("V").setNative(value);
    }

    public SpreadSheet toSpreadSheet() {
        return this.m_Data;
    }

    public MetaData getClone() {
        return new MetaData(this);
    }

    public String toString() {
        return this.m_Data.toString();
    }
}

