/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.cellfinder;

import adams.core.ClassLister;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.cellfinder.CellFinder;
import adams.data.spreadsheet.cellfinder.CellLocation;
import java.util.Iterator;

public abstract class AbstractCellFinder
extends AbstractOptionHandler
implements CellFinder {
    private static final long serialVersionUID = 3647241823201101006L;

    public String getQuickInfo() {
        return null;
    }

    protected void check(SpreadSheet sheet) {
        if (sheet == null) {
            throw new IllegalArgumentException("No spreadsheet provided!");
        }
    }

    protected abstract Iterator<CellLocation> doFindCells(SpreadSheet var1);

    @Override
    public Iterator<CellLocation> findCells(SpreadSheet sheet) {
        this.check(sheet);
        return this.doFindCells(sheet);
    }

    public CellFinder shallowCopy() {
        return this.shallowCopy(false);
    }

    public CellFinder shallowCopy(boolean expand) {
        return (CellFinder)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }

    public static String[] getCellFinders() {
        return ClassLister.getSingleton().getClassnames(CellFinder.class);
    }

    public static CellFinder forName(String classname, String[] options) {
        CellFinder result;
        try {
            result = (CellFinder)OptionUtils.forName(CellFinder.class, (String)classname, (String[])options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static CellFinder forCommandLine(String cmdline) {
        return (CellFinder)AbstractOptionConsumer.fromString(ArrayConsumer.class, (String)cmdline);
    }
}

