/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.matrixstatistic;

import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.matrixstatistic.AbstractMatrixStatistic;

public class Missing
extends AbstractMatrixStatistic {
    private static final long serialVersionUID = 330391755072250767L;

    public String globalInfo() {
        return "Counts the missing cells in the spreadsheet.";
    }

    @Override
    protected SpreadSheet doGenerate(SpreadSheet sheet) {
        DataRow row;
        SpreadSheet result = this.createOutputHeader();
        int count = 0;
        for (int i = 0; i < sheet.getRowCount(); ++i) {
            row = sheet.getRow(i);
            for (int n = 0; n < sheet.getColumnCount(); ++n) {
                if (!row.hasCell(n)) {
                    ++count;
                    continue;
                }
                if (!row.getCell(n).isMissing()) continue;
                ++count;
            }
        }
        row = result.addRow();
        row.addCell(0).setContent("Missing");
        row.addCell(1).setContent(Integer.valueOf(count));
        return result;
    }
}

