/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowscore;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.SpreadSheetView;
import adams.data.spreadsheet.rowscore.AbstractMetaRowScore;

public class ColumnSubset
extends AbstractMetaRowScore {
    private static final long serialVersionUID = -9037884201569670797L;
    protected SpreadSheetColumnRange m_Columns;

    public String globalInfo() {
        return "Applies the specified base row score algorithm to the specified subset of columns and returns the calculated score.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "columns", (Object)new SpreadSheetColumnRange("first-last"));
    }

    @Override
    public String rowScoreTipText() {
        return "The row score algorithm to apply to the column subset.";
    }

    public void setColumns(SpreadSheetColumnRange value) {
        this.m_Columns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The range of columns to apply the specified row score algorithm to.";
    }

    @Override
    protected Double[] doCalculateScore(SpreadSheet sheet, int rowIndex) {
        Double[] result = null;
        this.m_Columns.setData(sheet);
        SpreadSheetView subset = new SpreadSheetView(sheet, null, this.m_Columns.getIntIndices());
        result = this.m_RowScore.calculateScore((SpreadSheet)subset, rowIndex);
        return result;
    }
}

