/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowscore;

import adams.core.Utils;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowscore.AbstractMetaRowScore;

public class EqualWidthBins
extends AbstractMetaRowScore {
    private static final long serialVersionUID = -9037884201569670797L;
    protected int m_NumBins;

    public String globalInfo() {
        return "Splits the row into bins with (more or less) same size and applies the base score algorithm to each of the bins.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-bins", "numBins", (Object)1, (Number)1, null);
    }

    @Override
    public String rowScoreTipText() {
        return "The row score algorithm to apply to the each of the bins.";
    }

    public void setNumBins(int value) {
        this.m_NumBins = value;
        this.reset();
    }

    public int getNumBins() {
        return this.m_NumBins;
    }

    public String numBinsTipText() {
        return "The number of bins to use.";
    }

    @Override
    public int getNumScores() {
        return this.m_NumBins * this.m_RowScore.getNumScores();
    }

    @Override
    protected Double[] doCalculateScore(SpreadSheet sheet, int rowIndex) {
        Double[] result = null;
        if (sheet.getColumnCount() >= this.m_NumBins) {
            int i;
            int[] bins = new int[this.m_NumBins + 1];
            bins[0] = 0;
            for (i = 0; i < this.m_NumBins; ++i) {
                bins[i + 1] = sheet.getColumnCount() / this.m_NumBins * (i + 1);
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("bins: " + Utils.arrayToString((Object)bins));
            }
            DataRow rowOld = sheet.getRow(rowIndex);
            result = new Double[this.getNumScores()];
            for (i = 0; i < this.m_NumBins; ++i) {
                int n;
                DefaultSpreadSheet subset = new DefaultSpreadSheet();
                HeaderRow rowNew = subset.getHeaderRow();
                for (n = bins[i]; n < bins[i + 1]; ++n) {
                    rowNew.addCell("" + n).setContent("H-" + n);
                }
                rowNew = subset.addRow();
                for (n = bins[i]; n < bins[i + 1]; ++n) {
                    if (rowOld.hasCell(n)) {
                        rowNew.addCell("" + n).assign(rowOld.getCell(n));
                        continue;
                    }
                    rowNew.addCell("" + n).setMissing();
                }
                Double[] scores = this.m_RowScore.calculateScore((SpreadSheet)subset, 0);
                if (scores == null) continue;
                for (n = 0; n < scores.length; ++n) {
                    result[i * this.m_RowScore.getNumScores() + n] = scores[n];
                }
            }
        }
        return result;
    }
}

