/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.sql;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.sql.AbstractTypeMapper;

public class DefaultTypeMapper
extends AbstractTypeMapper {
    private static final long serialVersionUID = -4158991121487239476L;

    public String globalInfo() {
        return "Default type mapper, works with MySQL and PostgreSQL.";
    }

    @Override
    public Cell.ContentType sqlTypeToContentType(int colType) {
        switch (colType) {
            case 92: {
                return Cell.ContentType.TIME;
            }
            case 91: {
                return Cell.ContentType.DATE;
            }
            case 93: {
                return Cell.ContentType.DATETIMEMSEC;
            }
            case 4: {
                return Cell.ContentType.LONG;
            }
            case -5: {
                return Cell.ContentType.LONG;
            }
            case 6: {
                return Cell.ContentType.DOUBLE;
            }
            case 8: {
                return Cell.ContentType.DOUBLE;
            }
            case 3: {
                return Cell.ContentType.DOUBLE;
            }
        }
        return Cell.ContentType.STRING;
    }

    @Override
    public int contentTypeToSqlType(Cell.ContentType contentType) {
        switch (contentType) {
            case DATE: {
                return 91;
            }
            case DATETIME: {
                return 93;
            }
            case DATETIMEMSEC: {
                return 93;
            }
            case TIME: {
                return 92;
            }
            case TIMEMSEC: {
                return 92;
            }
            case DOUBLE: {
                return 8;
            }
            case LONG: {
                return 4;
            }
            case BOOLEAN: {
                return 16;
            }
        }
        return 12;
    }

    @Override
    public String contentTypeToSqlCreateType(Cell.ContentType contentType, String stringType) {
        switch (contentType) {
            case LONG: {
                return "INTEGER";
            }
            case DOUBLE: {
                return "DOUBLE PRECISION";
            }
            case DATE: {
                return "DATE";
            }
            case DATETIME: 
            case DATETIMEMSEC: {
                return "TIMESTAMP";
            }
            case TIME: 
            case TIMEMSEC: {
                return "TIME";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
        }
        return stringType;
    }
}

