/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.sql;

import adams.core.Stoppable;
import adams.core.logging.LoggingLevel;
import adams.core.logging.LoggingObject;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.sql.AbstractTypeMapper;
import adams.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Reader
extends LoggingObject
implements Stoppable {
    private static final long serialVersionUID = -958340824375198629L;
    protected Class m_RowClass;
    protected AbstractTypeMapper m_TypeMapper;
    protected boolean m_Finished;
    protected boolean m_Stopped;
    protected SpreadSheet m_Header;
    protected int[] m_Type;

    public Reader(AbstractTypeMapper typeMapper, Class rowClass) {
        if (rowClass == null) {
            throw new IllegalArgumentException("No row class specified!");
        }
        this.m_TypeMapper = typeMapper;
        this.m_RowClass = rowClass;
        this.m_Header = null;
        this.m_Type = new int[0];
    }

    public void setLoggingLevel(LoggingLevel value) {
        this.m_LoggingLevel = value;
    }

    public void initHeader(ResultSet rs) throws SQLException {
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        result.setDataRowClass(this.getRowClass());
        HeaderRow row = result.getHeaderRow();
        this.m_Type = SQLUtils.getColumnTypes((ResultSet)rs);
        String[] names = SQLUtils.getColumnNames((ResultSet)rs);
        for (int i = 1; i <= names.length; ++i) {
            row.addCell("" + i).setContentAsString(names[i - 1]);
        }
        this.m_Header = result.getHeader();
    }

    public Class getRowClass() {
        return this.m_RowClass;
    }

    public AbstractTypeMapper getTypeMapper() {
        return this.m_TypeMapper;
    }

    public SpreadSheet getHeader() {
        return this.m_Header;
    }

    public SpreadSheet read(ResultSet rs) throws SQLException {
        return this.read(rs, -1);
    }

    public SpreadSheet read(ResultSet rs, int max) throws SQLException {
        this.m_Stopped = false;
        this.m_Finished = false;
        if (this.m_Header == null) {
            this.initHeader(rs);
            this.m_Finished = !rs.next();
        }
        SpreadSheet result = this.m_Header.getHeader();
        while (!this.m_Finished && !this.m_Stopped) {
            DataRow row = result.addRow();
            block11: for (int i = 1; i <= result.getColumnCount(); ++i) {
                Cell.ContentType type = this.m_TypeMapper.sqlTypeToContentType(this.m_Type[i - 1]);
                rs.getObject(i);
                if (rs.wasNull()) {
                    row.getCell(i - 1).setMissing();
                    continue;
                }
                switch (type) {
                    case TIME: {
                        row.addCell(i - 1).setContentAs("" + rs.getTime(i), type);
                        continue block11;
                    }
                    case TIMEMSEC: {
                        row.addCell(i - 1).setContentAs("" + rs.getTime(i), type);
                        continue block11;
                    }
                    case DATE: {
                        row.addCell(i - 1).setContentAs("" + rs.getDate(i), type);
                        continue block11;
                    }
                    case DATETIME: {
                        row.addCell(i - 1).setContentAs("" + rs.getTimestamp(i), type);
                        continue block11;
                    }
                    case DATETIMEMSEC: {
                        row.addCell(i - 1).setContentAs("" + rs.getTimestamp(i), type);
                        continue block11;
                    }
                    case LONG: {
                        row.addCell(i - 1).setContent(Long.valueOf(rs.getLong(i)));
                        continue block11;
                    }
                    case DOUBLE: {
                        row.addCell(i - 1).setContent(Double.valueOf(rs.getDouble(i)));
                        continue block11;
                    }
                    case STRING: {
                        row.addCell(i - 1).setContentAsString(rs.getString(i));
                        continue block11;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled content type: " + type);
                    }
                }
            }
            boolean bl = this.m_Finished = !rs.next();
            if (max <= 0 || result.getRowCount() != max) continue;
        }
        if (this.m_Finished || this.m_Stopped) {
            SQLUtils.closeAll((ResultSet)rs);
        }
        return result;
    }

    public void stopExecution() {
        this.m_Stopped = true;
    }

    public boolean isStopped() {
        return this.m_Stopped;
    }

    public boolean isFinished() {
        return this.m_Finished;
    }
}

