/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.AbstractTextDisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.TextSupplier;
import adams.gui.core.BasePanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.visualization.container.DataContainerPanel;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.spreadsheet.AbstractSpreadSheetRowPaintlet;
import adams.gui.visualization.spreadsheet.AbstractSpreadSheetRowPanelUpdater;
import adams.gui.visualization.spreadsheet.SimpleSpreadSheetRowPanelUpdater;
import adams.gui.visualization.spreadsheet.SpreadSheetRow;
import adams.gui.visualization.spreadsheet.SpreadSheetRowContainer;
import adams.gui.visualization.spreadsheet.SpreadSheetRowContainerManager;
import adams.gui.visualization.spreadsheet.SpreadSheetRowLinePaintlet;
import adams.gui.visualization.spreadsheet.SpreadSheetRowPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;

public class SpreadSheetRowViewer
extends AbstractGraphicalDisplay
implements DisplayPanelProvider,
TextSupplier {
    private static final long serialVersionUID = 1283926389472133810L;
    protected SpreadSheetRowPanel m_SpreadSheetRowPanel;
    protected ColorProvider m_ColorProvider;
    protected AbstractSpreadSheetRowPaintlet m_Paintlet;
    protected boolean m_ZoomOverview;
    protected String m_ID;
    protected AbstractSpreadSheetRowPanelUpdater m_Updater;

    public String globalInfo() {
        return "Actor for displaying spreadsheet rows in a graphical way, like the 'Spreadsheet Explorer' tool.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)new DefaultColorProvider());
        this.m_OptionManager.add("paintlet", "paintlet", (Object)new SpreadSheetRowLinePaintlet());
        this.m_OptionManager.add("zoom-overview", "zoomOverview", (Object)false);
        this.m_OptionManager.add("id", "ID", (Object)"");
        this.m_OptionManager.add("updater", "updater", (Object)new SimpleSpreadSheetRowPanelUpdater());
    }

    protected int getDefaultWidth() {
        return 800;
    }

    protected int getDefaultHeight() {
        return 500;
    }

    public void setColorProvider(ColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public ColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider in use for coloring the rows.";
    }

    public void setPaintlet(AbstractSpreadSheetRowPaintlet value) {
        this.m_Paintlet = value;
        this.reset();
    }

    public AbstractSpreadSheetRowPaintlet getPaintlet() {
        return this.m_Paintlet;
    }

    public String paintletTipText() {
        return "The paintlet to use for drawing the rows.";
    }

    public void setZoomOverview(boolean value) {
        this.m_ZoomOverview = value;
        this.reset();
    }

    public boolean getZoomOverview() {
        return this.m_ZoomOverview;
    }

    public String zoomOverviewTipText() {
        return "If enabled, a zoom overview panel gets displayed as well.";
    }

    public void setID(String value) {
        this.m_ID = value;
        this.reset();
    }

    public String getID() {
        return this.m_ID;
    }

    public String IDTipText() {
        return "The name of the attribute/field to use as the ID in the display.";
    }

    public void setUpdater(AbstractSpreadSheetRowPanelUpdater value) {
        this.m_Updater = value;
        this.reset();
    }

    public AbstractSpreadSheetRowPanelUpdater getUpdater() {
        return this.m_Updater;
    }

    public String updaterTipText() {
        return "The updater in use for refreshing the visualization.";
    }

    public void clearPanel() {
        if (this.m_SpreadSheetRowPanel != null) {
            ((SpreadSheetRowContainerManager)this.m_SpreadSheetRowPanel.getContainerManager()).clear();
        }
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_SpreadSheetRowPanel = new SpreadSheetRowPanel();
        this.m_SpreadSheetRowPanel.setZoomOverviewPanelVisible(this.m_ZoomOverview);
        ((SpreadSheetRowContainerManager)this.m_SpreadSheetRowPanel.getContainerManager()).setColorProvider((ColorProvider)this.m_ColorProvider.shallowCopy(true));
        this.m_SpreadSheetRowPanel.setDataPaintlet(this.m_Paintlet.shallowCopy(true));
        result.add((Component)((Object)this.m_SpreadSheetRowPanel), (Object)"Center");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Row.class, SpreadSheetRow.class};
    }

    protected void display(Token token) {
        SpreadSheetRow row;
        if (token.getPayload() instanceof Row) {
            int col;
            Row srow = (Row)token.getPayload();
            row = new SpreadSheetRow();
            row.set(srow);
            if (!this.m_ID.isEmpty() && (col = srow.getOwner().getHeaderRow().indexOfContent(this.m_ID)) > -1 && srow.hasCell(col) && !srow.getCell(col).isMissing()) {
                row.setID(srow.getCell(col).getContent());
            }
        } else {
            row = (SpreadSheetRow)((Object)token.getPayload());
            if (row.hasReport() && row.getReport().hasValue(this.m_ID)) {
                row.setID("" + row.getReport().getValue((AbstractField)new Field(this.m_ID, DataType.UNKNOWN)));
            }
        }
        SpreadSheetRowContainerManager manager = (SpreadSheetRowContainerManager)this.m_SpreadSheetRowPanel.getContainerManager();
        SpreadSheetRowContainer cont = manager.newContainer((Comparable)((Object)row));
        manager.startUpdate();
        manager.add(cont);
        this.m_Updater.update((DataContainerPanel)this.m_SpreadSheetRowPanel, (Object)cont);
    }

    protected void cleanUpGUI() {
        super.cleanUpGUI();
        if (this.m_SpreadSheetRowPanel != null) {
            ((SpreadSheetRowContainerManager)this.m_SpreadSheetRowPanel.getContainerManager()).clear();
        }
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        AbstractTextDisplayPanel result = new AbstractTextDisplayPanel(((Object)((Object)this)).getClass().getSimpleName()){
            private static final long serialVersionUID = -5618543590920864397L;
            protected SpreadSheetRowPanel m_SpreadSheetRowPanel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_SpreadSheetRowPanel = new SpreadSheetRowPanel();
                this.add((Component)((Object)this.m_SpreadSheetRowPanel), "Center");
            }

            public void display(Token token) {
                SpreadSheetRow row;
                if (token.getPayload() instanceof Row) {
                    int col;
                    Row srow = (Row)token.getPayload();
                    row = new SpreadSheetRow();
                    row.set(srow);
                    if (!SpreadSheetRowViewer.this.m_ID.isEmpty() && (col = srow.getOwner().getHeaderRow().indexOfContent(SpreadSheetRowViewer.this.m_ID)) > -1 && srow.hasCell(col) && !srow.getCell(col).isMissing()) {
                        row.setID(srow.getCell(col).getContent());
                    }
                } else {
                    row = (SpreadSheetRow)((Object)token.getPayload());
                    if (row.hasReport() && row.getReport().hasValue(SpreadSheetRowViewer.this.m_ID)) {
                        row.setID("" + row.getReport().getValue((AbstractField)new Field(SpreadSheetRowViewer.this.m_ID, DataType.UNKNOWN)));
                    }
                }
                SpreadSheetRowContainerManager manager = (SpreadSheetRowContainerManager)this.m_SpreadSheetRowPanel.getContainerManager();
                SpreadSheetRowContainer cont = manager.newContainer((Comparable)((Object)row));
                manager.add(cont);
            }

            public ExtensionFileFilter getCustomTextFileFilter() {
                return new ExtensionFileFilter("CSV Spreadsheet", "csv");
            }

            public String supplyText() {
                return SpreadSheetRowViewer.supplyText(this.m_SpreadSheetRowPanel);
            }

            public void clearPanel() {
                ((SpreadSheetRowContainerManager)this.m_SpreadSheetRowPanel.getContainerManager()).clear();
            }

            public void cleanUp() {
                ((SpreadSheetRowContainerManager)this.m_SpreadSheetRowPanel.getContainerManager()).clear();
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public String getCustomSupplyTextMenuItemCaption() {
        return "Save spreadsheet as...";
    }

    public ExtensionFileFilter getCustomTextFileFilter() {
        return new ExtensionFileFilter("CSV Spreadsheet", "csv");
    }

    public String supplyText() {
        return SpreadSheetRowViewer.supplyText(this.m_SpreadSheetRowPanel);
    }

    protected static String supplyText(SpreadSheetRowPanel panel) {
        if (panel == null) {
            return null;
        }
        SpreadSheetRowContainerManager manager = (SpreadSheetRowContainerManager)panel.getContainerManager();
        if (manager.countVisible() == 0) {
            return null;
        }
        SpreadSheet data = manager.getVisible(0).getData().getDatasetHeader().getHeader();
        for (int i = 0; i < manager.countVisible(); ++i) {
            data.addRow().assign(manager.getVisible(i).getData().toRow());
        }
        return data.toString();
    }

    public boolean displayPanelRequiresScrollPane() {
        return true;
    }

    public void wrapUp() {
        if (this.m_Panel != null) {
            this.m_Updater.update((DataContainerPanel)this.m_SpreadSheetRowPanel);
        }
        super.wrapUp();
    }
}

