/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DataRowTypeHandler;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.sql.AbstractTypeMapper;
import adams.data.spreadsheet.sql.DefaultTypeMapper;
import adams.data.spreadsheet.sql.Reader;
import adams.db.AbstractDatabaseConnection;
import adams.db.SQLF;
import adams.db.SQLStatement;
import adams.flow.core.Token;
import adams.flow.source.AbstractDbSource;
import java.sql.ResultSet;

public abstract class AbstractSpreadSheetDbReader
extends AbstractDbSource
implements DataRowTypeHandler {
    private static final long serialVersionUID = 494594301273926225L;
    protected AbstractTypeMapper m_TypeMapper;
    protected SQLStatement m_Query;
    protected DataRow m_DataRowType;
    protected int m_ChunkSize;
    protected Token m_OutputToken;
    protected Reader m_Reader;
    protected transient ResultSet m_ResultSet;

    public String globalInfo() {
        return "Returns a spreadsheet object generated from an SQL query.\nTo optimize memory consumption, you can return the result of the query in chunks of a specified size.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type-mapper", "typeMapper", (Object)new DefaultTypeMapper());
        this.m_OptionManager.add("query", "query", (Object)new SQLStatement("select * from blah"));
        this.m_OptionManager.add("data-row-type", "dataRowType", (Object)new DenseDataRow());
        this.m_OptionManager.add("chunk-size", "chunkSize", (Object)-1, (Number)-1, null);
    }

    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"query", (Object)Shortening.shortenEnd((String)this.m_Query.stringValue(), (int)40), (String)"query: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"dataRowType", (Object)this.m_DataRowType, (String)", row type: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"chunkSize", (Object)(this.m_ChunkSize > 0 ? Integer.valueOf(this.m_ChunkSize) : null), (String)", chunk: ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    public void setTypeMapper(AbstractTypeMapper value) {
        this.m_TypeMapper = value;
        this.reset();
    }

    public AbstractTypeMapper getTypeMapper() {
        return this.m_TypeMapper;
    }

    public String typeMapperTipText() {
        return "The type mapper to use for mapping spreadsheet and SQL types.";
    }

    public void setQuery(SQLStatement value) {
        this.m_Query = value;
        this.reset();
    }

    public SQLStatement getQuery() {
        return this.m_Query;
    }

    public String queryTipText() {
        return "The SQL query to use for generating the spreadsheet.";
    }

    public void setDataRowType(DataRow value) {
        this.m_DataRowType = value;
        this.reset();
    }

    public DataRow getDataRowType() {
        return this.m_DataRowType;
    }

    public String dataRowTypeTipText() {
        return "The type of row to use for the data.";
    }

    public void setChunkSize(int value) {
        if (value < 1) {
            value = -1;
        }
        this.m_ChunkSize = value;
        this.reset();
    }

    public int getChunkSize() {
        return this.m_ChunkSize;
    }

    public String chunkSizeTipText() {
        return "The maximum number of rows per chunk; using -1 will read put all data into a single spreadsheet object.";
    }

    protected abstract AbstractDatabaseConnection getDefaultDatabaseConnection();

    protected abstract AbstractDatabaseConnection getDatabaseConnection();

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected String queryDatabase() {
        String result = null;
        SpreadSheet sheet = null;
        String query = this.m_Query.getValue();
        query = this.getVariables().expand(query);
        try {
            SQLF sql = SQLF.getSingleton((AbstractDatabaseConnection)this.m_DatabaseConnection);
            sql.setDebug(this.isLoggingEnabled());
            this.m_Reader = new Reader(this.m_TypeMapper, this.m_DataRowType.getClass());
            this.m_Reader.setLoggingLevel(this.getLoggingLevel());
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Query: " + query);
            }
            this.m_ResultSet = sql.getResultSet(query);
            sheet = this.m_Reader.read(this.m_ResultSet, this.m_ChunkSize);
            if (this.m_Reader.isFinished() || this.m_Reader.isStopped()) {
                this.m_Reader = null;
                this.m_ResultSet = null;
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to retrieve data from database!\n" + query, e);
        }
        if (this.isStopped()) {
            result = null;
        }
        if (result == null) {
            this.m_OutputToken = new Token(sheet);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        if (this.m_OutputToken != null) {
            return true;
        }
        if (this.m_Reader == null) {
            return false;
        }
        if (this.m_ResultSet == null) {
            return false;
        }
        try {
            return !this.m_Reader.isFinished();
        }
        catch (Exception e) {
            this.handleException("Failed to query result set's closed state", e);
            return false;
        }
    }

    public Token output() {
        Token result = null;
        if (this.m_OutputToken != null) {
            result = this.m_OutputToken;
            this.m_OutputToken = null;
        } else {
            try {
                if (this.m_ResultSet != null && !this.m_Reader.isFinished()) {
                    result = new Token((Object)this.m_Reader.read(this.m_ResultSet, this.m_ChunkSize));
                }
                if (this.m_Reader.isFinished() || this.m_Reader.isStopped()) {
                    this.m_Reader = null;
                    this.m_ResultSet = null;
                }
            }
            catch (Exception e) {
                this.handleException("Failed to read the next chunk", e);
            }
        }
        return result;
    }

    public void stopExecution() {
        if (this.m_Reader != null) {
            this.m_Reader.stopExecution();
        }
        super.stopExecution();
    }

    public void wrapUp() {
        this.m_DatabaseConnection = null;
        this.m_Reader = null;
        this.m_ResultSet = null;
        super.wrapUp();
    }
}

