/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.RowIdentifier;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.HashSet;

public class SpreadSheetDifference
extends AbstractTransformer {
    private static final long serialVersionUID = -5056170789277731638L;
    protected SpreadSheetColumnRange m_KeyColumns;
    protected RowIdentifier[] m_Rows;
    protected int[] m_ColIndices;

    public String globalInfo() {
        return "Computes the difference of the numeric cells between two spreadsheets.\nThe values of the second spreadsheet are subtracted from the first one.\nIf no 'key' columns are defined, the current order of rows is used for comparison.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key-columns", "keyColumns", (Object)new SpreadSheetColumnRange(""));
    }

    protected void initialize() {
        super.initialize();
        this.m_KeyColumns = new SpreadSheetColumnRange();
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"keyColumns", (Object)((Object)this.m_KeyColumns), (String)"key columns: ");
    }

    public void setKeyColumns(SpreadSheetColumnRange value) {
        this.m_KeyColumns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getKeyColumns() {
        return this.m_KeyColumns;
    }

    public String keyColumnsTipText() {
        return "The columns to use as keys for identifying rows in the spreadsheets, if empty the row index is used instead; " + this.m_KeyColumns.getExample();
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet[].class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected void initRowLookup(SpreadSheet[] sheets) {
        if (this.m_Rows != null) {
            return;
        }
        this.m_Rows = new RowIdentifier[2];
        this.m_ColIndices = new int[0];
        if (this.m_KeyColumns.getRange().length() != 0) {
            this.m_KeyColumns.setSpreadSheet(sheets[0]);
            this.m_ColIndices = this.m_KeyColumns.getIntIndices();
            this.m_Rows[0] = new RowIdentifier((Range)this.m_KeyColumns);
            this.m_Rows[1] = new RowIdentifier((Range)this.m_KeyColumns);
            this.m_Rows[0].identify(sheets[0]);
            this.m_Rows[1].identify(sheets[1]);
        }
    }

    protected Row difference(SpreadSheet output, Row row1, Row row2) {
        Row result = row1.getClone(output);
        result.clear();
        HashSet<Integer> indices = new HashSet<Integer>();
        for (int i : this.m_ColIndices) {
            indices.add(this.m_ColIndices[i]);
        }
        Object object = row1.cellKeys().iterator();
        while (object.hasNext()) {
            String key = (String)object.next();
            int index = row1.getOwner().getHeaderRow().indexOf(key);
            Cell cell1 = row1.getCell(key);
            Cell cell2 = row2.getCell(key);
            if (indices.contains(index)) {
                result.addCell(key).setContent(cell1.getContent());
                continue;
            }
            if (cell1 == null || cell2 == null) {
                result.addCell(key).setContent("?");
                continue;
            }
            if (cell1.isMissing() || cell2.isMissing()) {
                result.addCell(key).setContent("?");
                continue;
            }
            if (cell1.isNumeric() && cell2.isNumeric()) {
                result.addCell(key).setContent(Double.valueOf(cell1.toDouble() - cell2.toDouble()));
                continue;
            }
            if (cell1.getContent().equals(cell2.getContent())) {
                result.addCell(key).setContent(cell1.getContent());
                continue;
            }
            result.addCell(key).setContent("?");
        }
        return result;
    }

    protected void generateOutputRow(SpreadSheet output, Row rowDiff) {
        HeaderRow header = output.getHeaderRow();
        DataRow rowNew = output.addRow();
        if (rowDiff != null) {
            for (int n = 0; n < header.getCellCount(); ++n) {
                String key = header.getCellKey(n);
                if (rowDiff.hasCell(key) && !rowDiff.getCell(key).isMissing()) {
                    rowNew.addCell(key).setContent(rowDiff.getCell(key).getContent());
                    continue;
                }
                rowNew.addCell(key).setContent("?");
            }
        }
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet[] sheets = (SpreadSheet[])this.m_InputToken.getPayload();
        this.m_Rows = null;
        if (sheets.length != 2) {
            result = "Expected two spreadsheets, received: " + sheets.length;
        } else {
            result = sheets[0].equalsHeader(sheets[0]);
            if (result != null) {
                result = "Spreadsheets not compatible: " + result;
            }
        }
        if (result == null) {
            SpreadSheet output = sheets[0].getHeader();
            this.initRowLookup(sheets);
            if (this.m_ColIndices.length > 0) {
                for (String key : this.m_Rows[0].getKeys()) {
                    DataRow row1 = sheets[0].getRow(((Integer)this.m_Rows[0].getRows(key).get(0)).intValue());
                    DataRow row2 = null;
                    if (this.m_Rows[1].getRows(key) != null) {
                        row2 = sheets[1].getRow(((Integer)this.m_Rows[1].getRows(key).get(0)).intValue());
                    }
                    if (row2 == null) continue;
                    this.generateOutputRow(output, this.difference(output, (Row)row1, (Row)row2));
                }
            } else {
                for (int n = 0; n < sheets[0].getRowCount() && n < sheets[1].getRowCount(); ++n) {
                    DataRow row1 = sheets[0].getRow(n);
                    DataRow row2 = sheets[1].getRow(n);
                    this.generateOutputRow(output, this.difference(output, (Row)row1, (Row)row2));
                }
            }
            this.m_OutputToken = new Token((Object)output);
        }
        this.m_Rows = null;
        this.m_ColIndices = null;
        return result;
    }
}

