/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.transformer.AbstractArrayProvider;

public class SpreadSheetGetCell
extends AbstractArrayProvider {
    private static final long serialVersionUID = -253714973019682939L;
    protected Range m_Row;
    protected SpreadSheetColumnRange m_Column;
    protected String m_Empty;
    protected boolean m_UseNative;

    public String globalInfo() {
        return "Extracts one or more values from a spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row", "row", (Object)new Range("1"));
        this.m_OptionManager.add("col", "column", (Object)new SpreadSheetColumnRange("1"));
        this.m_OptionManager.add("empty", "empty", (Object)"");
        this.m_OptionManager.add("use-native", "useNative", (Object)false);
    }

    protected void initialize() {
        super.initialize();
        this.m_Row = new Range();
        this.m_Column = new SpreadSheetColumnRange();
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"row", (Object)this.m_Row, (String)"row: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"column", (Object)((Object)this.m_Column), (String)"/col: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"empty", (Object)(this.m_Empty.length() > 0 ? this.m_Empty : null), (String)", empty: ");
        if (value != null) {
            result = result + value;
        }
        if ((value = QuickInfoHelper.toString((OptionHandler)this, (String)"useNative", (boolean)this.m_UseNative, (String)", native")) != null) {
            result = result + value;
        }
        return result;
    }

    protected Class getItemClass() {
        if (this.m_UseNative) {
            return Object.class;
        }
        return String.class;
    }

    public String outputArrayTipText() {
        return "Whether to output the cell values in an array or one-by-one.";
    }

    public void setRow(Range value) {
        this.m_Row = value;
        this.reset();
    }

    public Range getRow() {
        return this.m_Row;
    }

    public String rowTipText() {
        return "The row(s) of the cell(s) to retrieve.";
    }

    public void setColumn(SpreadSheetColumnRange value) {
        this.m_Column = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column(s) of the cell(s) to retrieve; " + this.m_Column.getExample();
    }

    public void setEmpty(String value) {
        this.m_Empty = value;
        this.reset();
    }

    public String getEmpty() {
        return this.m_Empty;
    }

    public String emptyTipText() {
        return "The value to return in case the cell is empty.";
    }

    public void setUseNative(boolean value) {
        this.m_UseNative = value;
        this.reset();
    }

    public boolean getUseNative() {
        return this.m_UseNative;
    }

    public String useNativeTipText() {
        return "If enabled, native objects are output rather than strings.";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class, Row.class};
    }

    protected String doExecute() {
        String result;
        block10: {
            block9: {
                result = null;
                if (!(this.m_InputToken.getPayload() instanceof SpreadSheet)) break block9;
                SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
                this.m_Row.setMax(sheet.getRowCount());
                this.m_Column.setSpreadSheet(sheet);
                int[] rows = this.m_Row.getIntIndices();
                int[] cols = this.m_Column.getIntIndices();
                if (rows.length == 0) {
                    result = "No rows selected? " + this.m_Row.getRange();
                } else if (cols.length == 0) {
                    result = "No columns selected? " + this.m_Column.getRange();
                } else {
                    for (int r : rows) {
                        for (int c : cols) {
                            Cell cell = sheet.getCell(r, c);
                            Object value = cell == null ? this.m_Empty : (cell.isMissing() ? "?" : (this.m_UseNative ? cell.getNative() : cell.getContent()));
                            this.m_Queue.add(value);
                        }
                    }
                }
                break block10;
            }
            if (!(this.m_InputToken.getPayload() instanceof Row)) break block10;
            Row row = (Row)this.m_InputToken.getPayload();
            this.m_Column.setSpreadSheet(row.getOwner());
            int[] cols = this.m_Column.getIntIndices();
            if (cols.length == 0) {
                result = "No columns selected? " + this.m_Column.getRange();
            } else {
                for (int c : cols) {
                    Cell cell = row.getCell(c);
                    Object value = cell == null ? this.m_Empty : (cell.isMissing() ? "?" : (this.m_UseNative ? cell.getNative() : cell.getContent()));
                    this.m_Queue.add(value);
                }
            }
        }
        return result;
    }
}

