/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.base.BaseString;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.statistics.ArrayHistogram;
import adams.flow.transformer.AbstractArrayProvider;
import adams.flow.transformer.SpreadSheetStatisticDataType;
import java.io.Serializable;

public class SpreadSheetHistogramRanges
extends AbstractArrayProvider {
    private static final long serialVersionUID = -540187402790189753L;
    protected SpreadSheetStatisticDataType m_DataType;
    protected BaseString[] m_Locations;
    protected ArrayHistogram.BinCalculation m_BinCalculation;
    protected int m_NumBins;
    protected double m_BinWidth;
    protected boolean m_Normalize;
    protected boolean m_UseFixedMinMax;
    protected double m_ManualMin;
    protected double m_ManualMax;
    protected int m_NumDecimals;

    public String globalInfo() {
        return "Outputs the ranges generated by " + ArrayHistogram.class.getName() + " using the incoming " + SpreadSheet.class.getName() + " object.\nIf cells aren't numeric or missing, a default value of zero is used.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "dataType", (Object)SpreadSheetStatisticDataType.COLUMN_BY_INDEX);
        this.m_OptionManager.add("location", "locations", (Object)new BaseString[0]);
        this.m_OptionManager.add("bin-calc", "binCalculation", (Object)ArrayHistogram.BinCalculation.MANUAL);
        this.m_OptionManager.add("num-bins", "numBins", (Object)50, (Number)1, null);
        this.m_OptionManager.add("bin-width", "binWidth", (Object)1.0, (Number)1.0E-5, null);
        this.m_OptionManager.add("normalize", "normalize", (Object)false);
        this.m_OptionManager.add("use-fixed-min-max", "useFixedMinMax", (Object)false);
        this.m_OptionManager.add("manual-min", "manualMin", (Object)0.0);
        this.m_OptionManager.add("manual-max", "manualMax", (Object)1.0);
        this.m_OptionManager.add("num-decimals", "numDecimals", (Object)3, (Number)0, null);
    }

    protected Class getItemClass() {
        return String.class;
    }

    public String outputArrayTipText() {
        return "If enabled, the ranges are output as array rather than one by one.";
    }

    public void setDataType(SpreadSheetStatisticDataType value) {
        this.m_DataType = value;
        this.reset();
    }

    public SpreadSheetStatisticDataType getDataType() {
        return this.m_DataType;
    }

    public String dataTypeTipText() {
        return "Whether to retrieve rows or columns from the Instances object.";
    }

    public void setLocations(BaseString[] value) {
        this.m_Locations = value;
        this.reset();
    }

    public BaseString[] getLocations() {
        return this.m_Locations;
    }

    public String locationsTipText() {
        return "The locations of the data, depending on the chosen data type that can be either indices, column names or regular expressions on the column names.";
    }

    public void setBinCalculation(ArrayHistogram.BinCalculation value) {
        this.m_BinCalculation = value;
        this.reset();
    }

    public ArrayHistogram.BinCalculation getBinCalculation() {
        return this.m_BinCalculation;
    }

    public String binCalculationTipText() {
        return "Defines how the number of bins are calculated.";
    }

    public void setNumBins(int value) {
        this.m_NumBins = value;
        this.reset();
    }

    public int getNumBins() {
        return this.m_NumBins;
    }

    public String numBinsTipText() {
        return "The number of bins to use in case of manual bin calculation.";
    }

    public void setBinWidth(double value) {
        this.m_BinWidth = value;
        this.reset();
    }

    public double getBinWidth() {
        return this.m_BinWidth;
    }

    public String binWidthTipText() {
        return "The bin width to use for some of the calculations.";
    }

    public void setNormalize(boolean value) {
        this.m_Normalize = value;
        this.reset();
    }

    public boolean getNormalize() {
        return this.m_Normalize;
    }

    public String normalizeTipText() {
        return "If set to true the data gets normalized first before the histogram is calculated.";
    }

    public void setUseFixedMinMax(boolean value) {
        this.m_UseFixedMinMax = value;
        this.reset();
    }

    public boolean getUseFixedMinMax() {
        return this.m_UseFixedMinMax;
    }

    public String useFixedMinMaxTipText() {
        return "If enabled, then the user-specified min/max values are used for the bin calculation rather than the min/max from the data (allows comparison of histograms when generating histograms over a range of arrays).";
    }

    public void setManualMin(double value) {
        this.m_ManualMin = value;
        this.reset();
    }

    public double getManualMin() {
        return this.m_ManualMin;
    }

    public String manualMinTipText() {
        return "The minimum to use when using manual binning with user-supplied min/max enabled.";
    }

    public void setManualMax(double value) {
        this.m_ManualMax = value;
        this.reset();
    }

    public double getManualMax() {
        return this.m_ManualMax;
    }

    public String manualMaxTipText() {
        return "The maximum to use when using manual binning with user-supplied max/max enabled.";
    }

    public void setNumDecimals(int value) {
        this.m_NumDecimals = value;
        this.reset();
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public String numDecimalsTipText() {
        return "The number of decimals to show in the bin descriptions.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"outputArray", (Object)(this.m_OutputArray ? "as array" : "one by one"));
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected Double[] getRow(SpreadSheet sheet, int index) {
        DataRow row = sheet.getRow(index);
        Double[] result = new Double[sheet.getColumnCount()];
        for (int i = 0; i < result.length; ++i) {
            Cell cell = row.getCell(i);
            result[i] = cell == null || cell.isMissing() || !cell.isNumeric() ? new Double(0.0) : new Double(cell.getContent());
        }
        return result;
    }

    protected Double[] getColumn(SpreadSheet sheet, int index) {
        Double[] result = new Double[sheet.getRowCount()];
        for (int i = 0; i < result.length; ++i) {
            DataRow row = sheet.getRow(i);
            Cell cell = row.getCell(index);
            result[i] = cell == null || cell.isMissing() || !cell.isNumeric() ? new Double(0.0) : new Double(cell.getContent());
        }
        return result;
    }

    protected String doExecute() {
        int i;
        SpreadSheet sheet;
        String result = null;
        this.m_Queue.clear();
        try {
            sheet = null;
            SpreadSheet data = (SpreadSheet)this.m_InputToken.getPayload();
            ArrayHistogram stat = new ArrayHistogram();
            stat.setBinCalculation(this.m_BinCalculation);
            stat.setNumBins(this.m_NumBins);
            stat.setBinWidth(this.m_BinWidth);
            stat.setNormalize(this.m_Normalize);
            stat.setUseFixedMinMax(this.m_UseFixedMinMax);
            stat.setManualMin(this.m_ManualMin);
            stat.setManualMax(this.m_ManualMax);
            stat.setDisplayRanges(true);
            stat.setNumDecimals(this.m_NumDecimals);
            block7: for (i = 0; i < this.m_Locations.length; ++i) {
                switch (this.m_DataType) {
                    case ROW_BY_INDEX: {
                        Object index = new Index(this.m_Locations[i].stringValue());
                        index.setMax(data.getRowCount());
                        stat.add((Serializable[])this.getRow(data, index.getIntIndex()));
                        continue block7;
                    }
                    case COLUMN_BY_INDEX: {
                        Object index = new SpreadSheetColumnIndex(this.m_Locations[i].stringValue());
                        ((SpreadSheetColumnIndex)((Object)index)).setData(data);
                        stat.add((Serializable[])this.getColumn(data, index.getIntIndex()));
                        continue block7;
                    }
                    case COLUMN_BY_REGEXP: {
                        for (int n = 0; n < data.getColumnCount(); ++n) {
                            if (!data.getHeaderRow().getCell(n).getContent().matches(this.m_Locations[i].stringValue())) continue;
                            stat.add((Serializable[])this.getColumn(data, n));
                            continue block7;
                        }
                        continue block7;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled data type: " + (Object)((Object)this.m_DataType));
                    }
                }
            }
            sheet = stat.calculate().toSpreadSheet();
        }
        catch (Exception e) {
            result = this.handleException("Error generating the ranges: ", e);
            sheet = null;
        }
        if (sheet != null) {
            for (i = 0; i < sheet.getColumnCount(); ++i) {
                this.m_Queue.add(sheet.getColumnName(i));
            }
        }
        return result;
    }
}

